/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.md5;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    private static final byte[] block = new byte[1024];
    private static final int blockSize = 1024;

    public static String getMD5Txt(String data) throws NoSuchAlgorithmException {
        byte[] md5 = MD5Utils.getMD5Text(data.getBytes(StandardCharsets.UTF_8));
        BigInteger bigInt = new BigInteger(1, md5);
        return bigInt.toString(16).toUpperCase();
    }

    private static synchronized byte[] getMD5Text(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        int number = data.length / 1024;
        int remainder = data.length % 1024;
        for (int i = 0; i < number; ++i) {
            md5.update(data, 1024 * i, 1024);
        }
        if (remainder > 0) {
            md5.update(data, 1024 * number, remainder);
        }
        byte[] result = md5.digest();
        md5.reset();
        return result;
    }

    public static String getMD5Txt(File file) {
        try {
            byte[] md5 = MD5Utils.getMD5(file);
            BigInteger bigInt = new BigInteger(1, md5);
            return bigInt.toString(16).toUpperCase();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] getMD5(File file) throws IOException, NoSuchAlgorithmException {
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            byte[] byArray = MD5Utils.getMD5(in);
            return byArray;
        }
    }

    private static synchronized byte[] getMD5(InputStream data) throws IOException, NoSuchAlgorithmException {
        int read;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        while ((read = data.read(block, 0, 1024)) > -1) {
            md5.update(block, 0, read);
        }
        byte[] result = md5.digest();
        md5.reset();
        return result;
    }
}

