/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.md5;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    public static String getMD5Txt(String data) throws NoSuchAlgorithmException {
        return MD5Utils.getMD5(data.getBytes()).toString(16).toUpperCase();
    }

    public static BigInteger getMD5(String data) throws NoSuchAlgorithmException {
        return MD5Utils.getMD5(data.getBytes());
    }

    public static BigInteger getMD5(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        BigInteger bigInt = new BigInteger(1, md5.digest());
        return bigInt;
    }

    public static String getMD5Txt(File file) {
        try {
            byte[] md5 = MD5Utils.getMD5(file);
            BigInteger bigInt = new BigInteger(1, md5);
            return bigInt.toString(16).toUpperCase();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] getMD5(File file) throws IOException, NoSuchAlgorithmException {
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            byte[] byArray = MD5Utils.getMD5(in);
            return byArray;
        }
    }

    public static byte[] getMD5(InputStream data) throws IOException, NoSuchAlgorithmException {
        int read;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] buffer = new byte[8192];
        while ((read = data.read(buffer, 0, 8192)) > -1) {
            md5.update(buffer, 0, read);
        }
        return md5.digest();
    }
}

