/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;

public class JsonUtils {
    public static <T1, T2> T2 buildObject(T1 value, Class<T2> valueType) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsn = objectMapper.writeValueAsString(value);
        return (T2)objectMapper.readValue(jsn, valueType);
    }

    public static <T> T buildObject(String value, Class<T> valueType) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (T)objectMapper.readValue(value, valueType);
    }

    public static <T> T buildObjectWithoutException(String value, Class<T> valueType) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (T)objectMapper.readValue(value, valueType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Object> buildMapWithDefault(String value, Map<String, Object> defaultValue) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (Map)objectMapper.readValue(value, Map.class);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T> T buildObject(Map map, Class<T> valueType) throws JsonParseException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String jsn = objectMapper.writeValueAsString((Object)map);
            return (T)objectMapper.readValue(jsn, valueType);
        }
        catch (JsonProcessingException je) {
            throw new JsonParseException(null, je.getMessage());
        }
        catch (IOException ie) {
            throw new JsonParseException(null, ie.getMessage());
        }
    }

    public static <T> T buildObjectWithoutException(Map map, Class<T> valueType) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String jsn = objectMapper.writeValueAsString((Object)map);
            return (T)objectMapper.readValue(jsn, valueType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> String buildJson(T value) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString(value);
        return json;
    }

    public static <T> String buildJsonWithoutException(T value) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString(value);
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T clone(T value) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString(value);
            return (T)objectMapper.readValue(json, value.getClass());
        }
        catch (Exception e) {
            return null;
        }
    }
}

