/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.jar.info;

import cn.foxtech.common.utils.MapUtils;
import cn.foxtech.common.utils.jar.info.JarInfoEntity;
import cn.foxtech.common.utils.jar.info.JarInfoItem;
import cn.foxtech.common.utils.xml.XmlReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarInfoReader {
    public static Set<String> readClassName(String jarFilePath) throws IOException {
        Map<String, Object> jarInfo = JarInfoReader.readJarInfo(jarFilePath);
        return (Set)jarInfo.get("classFileName");
    }

    public static Set<String> readDirectoryName(String jarFilePath) throws IOException {
        Map<String, Object> jarInfo = JarInfoReader.readJarInfo(jarFilePath);
        return (Set)jarInfo.get("directoryName");
    }

    public static JarInfoEntity readJarInfoEntity(String jarFilePath) throws IOException {
        Map<String, Object> jarInfo = JarInfoReader.readJarInfo(jarFilePath);
        JarInfoEntity entity = new JarInfoEntity();
        entity.getClassFileName().addAll((Set)jarInfo.get("classFileName"));
        entity.getDirectoryName().addAll((Set)jarInfo.get("directoryName"));
        String xml = JarInfoReader.readPomXml(jarFilePath, (String)jarInfo.get("pom.xml"));
        Map jarXml = XmlReader.parse((String)xml);
        Object xmlEl = MapUtils.getValue((Map)jarXml, (Object[])new Object[]{"project", "dependencies", "dependency"});
        List dependencies = new ArrayList<Map>();
        if (xmlEl != null) {
            if (xmlEl instanceof Map) {
                dependencies.add((Map)xmlEl);
            }
            if (xmlEl instanceof List) {
                dependencies = (List)xmlEl;
            }
        }
        for (Map dependency : dependencies) {
            JarInfoItem item = new JarInfoItem();
            item.setGroupId((String)dependency.get("groupId"));
            item.setArtifactId((String)dependency.get("artifactId"));
            item.setVersion((String)dependency.get("version"));
            entity.getDependencies().add(item);
        }
        byte[] bytes = JarInfoReader.getFileFromJar(jarFilePath, "pom.properties");
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(bytes));
        entity.getProperties().setGroupId(properties.getProperty("groupId"));
        entity.getProperties().setArtifactId(properties.getProperty("artifactId"));
        entity.getProperties().setVersion(properties.getProperty("version"));
        return entity;
    }

    public static Map<String, Object> readJarInfo(String jarFilePath) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> dirNames = new HashSet<String>();
        HashSet<String> classNames = new HashSet<String>();
        result.put("directoryName", dirNames);
        result.put("classFileName", classNames);
        ZipInputStream zip = new ZipInputStream(Files.newInputStream(Paths.get(jarFilePath, new String[0]), new OpenOption[0]));
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (entry.isDirectory()) {
                dirNames.add(entry.getName());
            } else {
                if (entry.getName().endsWith(".class")) {
                    String className = entry.getName().replace('/', '.');
                    classNames.add(className.substring(0, className.length() - ".class".length()));
                }
                if (entry.getName().startsWith("META-INF/maven") && entry.getName().endsWith("pom.xml")) {
                    result.put("pom.xml", entry.getName());
                } else if (entry.getName().startsWith("META-INF/maven") && entry.getName().endsWith("pom.properties")) {
                    result.put("pom.properties", entry.getName());
                }
            }
            entry = zip.getNextEntry();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static byte[] getFileFromJar(String jarFilePath, String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Properties readPomProperties(String jarFilePath, String fileName) throws IOException {
        byte[] bytes = JarInfoReader.getFileFromJar(jarFilePath, fileName);
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(bytes));
        return properties;
    }

    public static Properties readPomProperties(String jarFilePath) throws IOException {
        Map<String, Object> jarInfo = JarInfoReader.readJarInfo(jarFilePath);
        byte[] bytes = JarInfoReader.getFileFromJar(jarFilePath, "pom.properties");
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(bytes));
        return properties;
    }

    public static String readPomXml(String jarFilePath) throws IOException {
        Map<String, Object> jarInfo = JarInfoReader.readJarInfo(jarFilePath);
        return JarInfoReader.readPomXml(jarFilePath, (String)jarInfo.get("pom.xml"));
    }

    public static String readPomXml(String jarFilePath, String fileName) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        byte[] bytes = JarInfoReader.getFileFromJar(jarFilePath, fileName);
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        BufferedInputStream in = new BufferedInputStream(bi);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        bi.close();
        in.close();
        br.close();
        return sb.toString();
    }
}

