/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.jar.info;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarInfoUtils {
    public static Set<String> scanClassNames(String path, String jarFile) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        ZipInputStream zip = new ZipInputStream(Files.newInputStream(Paths.get(path + jarFile, new String[0]), new OpenOption[0]));
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                String className = entry.getName().replace('/', '.');
                classNames.add(className.substring(0, className.length() - ".class".length()));
            }
            entry = zip.getNextEntry();
        }
        return classNames;
    }

    public static Map<String, Set<String>> scanFile2Class(String path, List<String> jarFiles) throws IOException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String jarFile : jarFiles) {
            Set<String> classNames = JarInfoUtils.scanClassNames(path, jarFile);
            map.put(jarFile, classNames);
        }
        return map;
    }

    public static Map<String, Set<String>> scanClass2File(String path, List<String> jarFiles) throws IOException {
        HashMap<String, Set<String>> class2file = new HashMap<String, Set<String>>();
        Map<String, Set<String>> file2class = JarInfoUtils.scanFile2Class(path, jarFiles);
        for (String fileName : file2class.keySet()) {
            Set<String> classNames = file2class.get(fileName);
            for (String className : classNames) {
                Set files = class2file.computeIfAbsent(className, k -> new HashSet());
                files.add(fileName);
            }
        }
        return class2file;
    }

    public static Map<String, Set<String>> checkConflictClass2Files(String path, List<String> jarFiles) throws IOException {
        HashMap<String, Set<String>> class2file4result = new HashMap<String, Set<String>>();
        Map<String, Set<String>> class2file = JarInfoUtils.scanClass2File(path, jarFiles);
        for (String className : class2file.keySet()) {
            Set<String> files = class2file.get(className);
            if (files.size() <= 1) continue;
            Set sets = class2file4result.computeIfAbsent(className, k -> new HashSet());
            sets.addAll(files);
        }
        return class2file4result;
    }

    public static Map<String, Set<String>> checkConflictFile2Class(String path, List<String> jarFiles) throws IOException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Map<String, Set<String>> class2file4conflict = JarInfoUtils.checkConflictClass2Files(path, jarFiles);
        for (String className : class2file4conflict.keySet()) {
            Set<String> files = class2file4conflict.get(className);
            for (String file : files) {
                Set sets = result.computeIfAbsent(file, k -> new HashSet());
                sets.add(className);
            }
        }
        return result;
    }
}

