/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.iotdb;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.isession.pool.SessionDataSetWrapper;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class IoTDBSessionPool {
    private SessionPool sessionPool;

    public void initialize(String host, int port, String username, String password) {
        this.sessionPool = new SessionPool(host, port, username, password, 4);
    }

    public boolean isInitialize() {
        return this.sessionPool != null;
    }

    public void createDatabase(String database) throws IoTDBConnectionException, StatementExecutionException {
        block2: {
            try {
                this.sessionPool.createDatabase(database);
            }
            catch (StatementExecutionException e) {
                if (e.getStatusCode() == TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()) break block2;
                throw e;
            }
        }
    }

    public void insertRecord(String deviceId, long time, Map<String, Object> data) throws IoTDBConnectionException, StatementExecutionException {
        if (data == null || data.isEmpty()) {
            return;
        }
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : data.keySet()) {
            if (key.contains(".")) continue;
            Object value = data.get(key);
            if (value == null) {
                types.add(TSDataType.INT64);
            } else if (value instanceof Integer) {
                types.add(TSDataType.INT32);
            } else if (value instanceof Long) {
                types.add(TSDataType.INT64);
            } else if (value instanceof Float) {
                types.add(TSDataType.FLOAT);
            } else if (value instanceof Double) {
                types.add(TSDataType.DOUBLE);
            } else {
                if (!(value instanceof Boolean)) continue;
                types.add(TSDataType.BOOLEAN);
            }
            measurements.add(key);
            values.add(value);
        }
        if (values.isEmpty()) {
            return;
        }
        this.sessionPool.insertRecord(deviceId, time, measurements, types, values);
    }

    public SessionDataSetWrapper executeQuery(String deviceId, List<String> keys) throws IoTDBConnectionException, StatementExecutionException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (String key : keys) {
            sb.append(key + ", ");
        }
        sb.deleteCharAt(sb.length() - 2);
        sb.append("FROM ");
        sb.append(deviceId);
        return this.executeQueryStatement(sb.toString());
    }

    public List<List<Object>> readRecord(SessionDataSetWrapper dataSet) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            ArrayList<Number> row = new ArrayList<Number>();
            row.add(record.getTimestamp());
            for (Field field : record.getFields()) {
                TSDataType dataType = field.getDataType();
                Constable value = 0;
                value = dataType.equals((Object)TSDataType.INT32) ? Integer.valueOf(field.getIntV()) : (dataType.equals((Object)TSDataType.INT64) ? Long.valueOf(field.getLongV()) : (dataType.equals((Object)TSDataType.DOUBLE) ? Double.valueOf(field.getDoubleV()) : (dataType.equals((Object)TSDataType.FLOAT) ? (Constable)Float.valueOf(field.getFloatV()) : (Constable)(dataType.equals((Object)TSDataType.BOOLEAN) ? Boolean.valueOf(field.getBoolV()) : null))));
                row.add((Number)((Object)value));
            }
            result.add(row);
        }
        return result;
    }

    public SessionDataSetWrapper executeQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        if (this.sessionPool == null) {
            throw new IoTDBConnectionException("\u4f1a\u8bdd\u5df2\u65ad\u5f00!");
        }
        SessionDataSetWrapper dataSet = this.sessionPool.executeQueryStatement(sql);
        return dataSet;
    }

    public SessionDataSetWrapper lastDataQuery(String deviceId, List<String> keys, long lastTime) throws IoTDBConnectionException, StatementExecutionException {
        if (this.sessionPool == null) {
            throw new IoTDBConnectionException("\u4f1a\u8bdd\u5df2\u65ad\u5f00!");
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String key : keys) {
            paths.add(deviceId + "." + key);
        }
        return this.sessionPool.executeLastDataQuery(paths, lastTime, 60000L);
    }

    public void deleteData(String deviceId, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        if (this.sessionPool == null) {
            throw new IoTDBConnectionException("\u4f1a\u8bdd\u5df2\u65ad\u5f00!");
        }
        this.sessionPool.deleteData(deviceId + ".*", endTime);
    }

    public void deleteData(String deviceId, List<String> keys, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        if (this.sessionPool == null) {
            throw new IoTDBConnectionException("\u4f1a\u8bdd\u5df2\u65ad\u5f00!");
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String key : keys) {
            paths.add(deviceId + "." + key);
        }
        this.sessionPool.deleteData(paths, endTime);
    }
}

