/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.influxdb;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.WriteApi;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import java.time.Instant;
import java.util.List;

public class InfluxDB2Example {
    public static void main(String[] args) {
        String token = "2_CbvEBbE3MyP2mhPOnY3rsT904kzWK05bVi8vJNEICiVwpN-V9XhJMv12MITKZ1rhlIxjqUINSOcRjh5uFJCw==";
        String bucket = "foxedge";
        String org = "foxteam";
        InfluxDBClient client = InfluxDBClientFactory.create((String)"http://192.168.241.128:8086", (char[])token.toCharArray());
        String data = "mem,host=host1 used_percent=23.43234543";
        try (WriteApi writeApi = client.getWriteApi();){
            writeApi.writeRecord(bucket, org, WritePrecision.NS, data);
        }
        Point point = Point.measurement((String)"mem").addTag("host", "host1").addField("used_percent", 24.43234543).time(Instant.now(), WritePrecision.NS);
        try (WriteApi writeApi = client.getWriteApi();){
            writeApi.writePoint(bucket, org, point);
        }
        String query = "from(bucket: \"" + bucket + "\") |> range(start: -1h) |> filter(fn: (r) => r._measurement == \"mem\")";
        List tables = client.getQueryApi().query(query, org);
        System.out.println(tables);
    }
}

