/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.http;

import cn.foxtech.common.constant.HttpStatus;
import cn.foxtech.core.exception.ServiceException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeGet(String url, Map<String, String> param) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            URI uri;
            HttpGet httpGet;
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            if ((response = httpclient.execute((HttpUriRequest)(httpGet = new HttpGet(uri = builder.build())))).getStatusLine().getStatusCode() == HttpStatus.SUCCESS.intValue()) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeGet(String url, Map<String, String> param, Map<String, String> header) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            for (String key : header.keySet()) {
                httpGet.setHeader(key, header.get(key));
            }
            response = httpclient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == HttpStatus.SUCCESS.intValue()) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static String executeGet(String url) {
        HashMap<String, String> param = new HashMap<String, String>();
        return HttpClientUtil.executeGet(url, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePost(String url, String json, Map<String, String> header) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            for (String key : header.keySet()) {
                httpPost.setHeader(key, header.get(key));
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePut(String url, String json, Map<String, String> header) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPut httpPut = new HttpPut(url);
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPut.setEntity((HttpEntity)entity);
            for (String key : header.keySet()) {
                httpPut.setHeader(key, header.get(key));
            }
            response = httpClient.execute((HttpUriRequest)httpPut);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePut(String url, String json) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPut httpPut = new HttpPut(url);
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPut.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPut);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePost(String url, String json) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static <REQ, RSP> RSP executePost(String url, REQ requestVO, Class<RSP> rspClass) throws IOException {
        String requestJson = objectMapper.writeValueAsString(requestVO);
        String respondJson = HttpClientUtil.executePost(url, requestJson);
        try {
            Object respondVO = objectMapper.readValue(respondJson, rspClass);
            return (RSP)respondVO;
        }
        catch (Exception e) {
            throw new ServiceException("\u670d\u52a1\u7aef\u54cd\u5e94\u5f02\u5e38\uff1a" + respondJson);
        }
    }

    public static <REQ, RSP> RSP executePut(String url, REQ requestVO, Class<RSP> rspClass) throws IOException {
        String requestJson = objectMapper.writeValueAsString(requestVO);
        String respondJson = HttpClientUtil.executePut(url, requestJson);
        try {
            Object respondVO = objectMapper.readValue(respondJson, rspClass);
            return (RSP)respondVO;
        }
        catch (Exception e) {
            throw new ServiceException("\u670d\u52a1\u7aef\u54cd\u5e94\u5f02\u5e38\uff1a" + respondJson);
        }
    }

    public static <RSP> RSP executeGet(String url, Class<RSP> rspClass) throws IOException {
        String respondJson = HttpClientUtil.executeGet(url);
        try {
            Object respondVO = objectMapper.readValue(respondJson, rspClass);
            return (RSP)respondVO;
        }
        catch (Exception e) {
            throw new ServiceException("\u670d\u52a1\u7aef\u54cd\u5e94\u5f02\u5e38\uff1a" + respondJson);
        }
    }
}

