/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.http;

import cn.foxtech.common.constant.HttpStatus;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeGet(String url, Map<String, String> param) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            URI uri;
            HttpGet httpGet;
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            if ((response = httpclient.execute((HttpUriRequest)(httpGet = new HttpGet(uri = builder.build())))).getStatusLine().getStatusCode() == HttpStatus.SUCCESS.intValue()) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeGet(String url, Map<String, String> param, Map<String, String> header) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            for (String key : header.keySet()) {
                httpGet.setHeader(key, header.get(key));
            }
            response = httpclient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == HttpStatus.SUCCESS.intValue()) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static String executeGet(String url) {
        HashMap<String, String> param = new HashMap<String, String>();
        return HttpClientUtil.executeGet(url, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePost(String url, String json, Map<String, String> header) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            for (String key : header.keySet()) {
                httpPost.setHeader(key, header.get(key));
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executePost(String url, String json) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static <REQ, RSP> RSP executePost(String url, REQ requestVO, Class<RSP> rspClass) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String requestJson = objectMapper.writeValueAsString(requestVO);
        String respondJson = HttpClientUtil.executePost(url, requestJson);
        Object respondVO = objectMapper.readValue(respondJson, rspClass);
        return (RSP)respondVO;
    }

    public static <RSP> RSP executeGet(String url, Class<RSP> rspClass) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String respondJson = HttpClientUtil.executeGet(url);
        Object respondVO = objectMapper.readValue(respondJson, rspClass);
        return (RSP)respondVO;
    }

    public static void main(String[] args) throws IOException {
        String pass = "{\"username\":\"admin\",\"password\":\"admin123\"}";
        String result1 = HttpClientUtil.executePost("http://120.25.241.120:8080/auth/login", pass);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer eyJhbGciOiJIUzUxMiJ9.eyJ1c2VyX2lkIjoxLCJ1c2VyX2tleSI6ImVkZmYwY2I0LTI3NTctNDUyZS05MjFkLTcyNTYyNTQ2MjFmMiIsInVzZXJuYW1lIjoiYWRtaW4ifQ.VkVh8C5bRU-MwvQZIy6PSe9VRBJR-2mNcEex0jboikrLzwyCbwmmCRwkqiAFopx1LCNIQFAZHLX5_pZueem-Wg");
        String json = "{\n    \"edgeId\" : \"BFEBFBFF000906A3\",\n    \"entityTypeList\" : [\"DeviceValueEntity\"]\n}";
        String result = HttpClientUtil.executePost("http://120.25.241.120:8080/aggregator/config/timestamp", json, header);
        result = HttpClientUtil.executePost("http://120.25.241.120:8080/aggregator/config/timestamp", json, header);
        result = HttpClientUtil.executePost("http://120.25.241.120:8080/aggregator/config/timestamp", json, header);
    }
}

