/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class FileTextUtils {
    public static List<String> readTextFileLines(String fileName) throws IOException {
        String line;
        FileInputStream fis = new FileInputStream(fileName);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        isr.close();
        fis.close();
        return lines;
    }

    public static String readTextFile(String fileName) throws IOException {
        return FileTextUtils.readTextFile(fileName, StandardCharsets.UTF_8);
    }

    public static String readTextFile(String fileName, Charset cs) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        return FileTextUtils.readTextFile(fis, cs);
    }

    public static String readTextFile(File file) throws IOException {
        return FileTextUtils.readTextFile(file, StandardCharsets.UTF_8);
    }

    public static String readTextFile(File file, Charset cs) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return FileTextUtils.readTextFile(fis, cs);
    }

    public static String readTextFile(InputStream fis, Charset cs) throws IOException {
        String line;
        InputStreamReader isr = new InputStreamReader(fis, cs);
        BufferedReader br = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\r\n");
        }
        br.close();
        isr.close();
        fis.close();
        return sb.toString();
    }

    public static void writeTextFile(String fileName, String content, String charsetName) throws IOException {
        if (charsetName == null || charsetName.isEmpty()) {
            charsetName = "UTF-8";
        }
        FileOutputStream fos = new FileOutputStream(fileName);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fos, charsetName);
        BufferedWriter writer = new BufferedWriter(outputStreamWriter);
        writer.write(content);
        writer.close();
    }

    public static void writeTextFile(String filePath, List<String> list, String charsetName, boolean withBom) throws IOException {
        if (charsetName == null || charsetName.isEmpty()) {
            charsetName = "UTF-8";
        }
        FileOutputStream fos = new FileOutputStream(filePath);
        if (withBom) {
            byte[] bom = new byte[]{-17, -69, -65};
            fos.write(bom);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fos, charsetName);
        BufferedWriter writer = new BufferedWriter(outputStreamWriter);
        for (String s : list) {
            writer.write(s);
            writer.newLine();
        }
        writer.close();
    }
}

