/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.file;

import cn.foxtech.common.utils.osinfo.OSInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileNameUtils {
    public static void findFileList(String dir, boolean depth, boolean fullName, List<String> fileNames) {
        FileNameUtils.findFileList(new File(dir), depth, fullName, fileNames);
    }

    public static List<String> findFileList(String dir, boolean depth, boolean fullName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        FileNameUtils.findFileList(new File(dir), depth, fullName, fileNames);
        return fileNames;
    }

    public static void findFileList(File dir, boolean depth, boolean fullName, List<String> fileNames) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isFile()) {
                if (!fullName) {
                    fileNames.add(file.getName());
                    continue;
                }
                fileNames.add(file.getAbsolutePath());
                continue;
            }
            if (!depth) continue;
            FileNameUtils.findFileList(file, depth, fullName, fileNames);
        }
    }

    public static String getOsFilePath(String filePath) {
        if (OSInfo.isWindows()) {
            return filePath.replace("/", "\\");
        }
        if (OSInfo.isLinux()) {
            return filePath.replace("\\", "/");
        }
        return filePath.replace("\\", "/");
    }
}

