/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.file;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class FileCompareUtils {
    private static final byte[] data1 = new byte[1024];
    private static final byte[] data2 = new byte[1024];
    private static final int blockSize = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSameFile(String filePath1, String filePath2) {
        BufferedInputStream bis1 = null;
        BufferedInputStream bis2 = null;
        FileInputStream fis1 = null;
        FileInputStream fis2 = null;
        try {
            fis1 = new FileInputStream(filePath1);
            fis2 = new FileInputStream(filePath2);
            bis1 = new BufferedInputStream(fis1);
            bis2 = new BufferedInputStream(fis2);
            int len1 = bis1.available();
            int len2 = bis2.available();
            if (len1 != len2) {
                boolean bl = false;
                return bl;
            }
            boolean bl = FileCompareUtils.compareFile(bis1, bis2, len2);
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bis1 != null) {
                try {
                    bis1.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bis2 != null) {
                try {
                    bis2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fis1 != null) {
                try {
                    fis1.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fis2 != null) {
                try {
                    fis2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private static synchronized boolean compareFile(BufferedInputStream bis1, BufferedInputStream bis2, int len) throws IOException {
        int number = len / 1024;
        int remainder = len % 1024;
        for (int i = 0; i < number; ++i) {
            bis1.read(data1);
            bis2.read(data2);
            if (FileCompareUtils.compareBlock(1024)) continue;
            return false;
        }
        bis1.read(data1);
        bis2.read(data2);
        boolean result = FileCompareUtils.compareBlock(remainder);
        return result;
    }

    private static boolean compareBlock(int size) {
        for (int i = 0; i < size; ++i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }
}

