/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.file;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class IniFileReader {
    protected HashMap sections = new HashMap();
    private transient String currentSecion;
    private transient Properties current;

    public IniFileReader(String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        this.read(reader);
        reader.close();
    }

    protected void read(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            this.parseLine(line);
        }
    }

    protected void parseLine(String line) {
        if ((line = line.trim()).matches("\\[.*]")) {
            this.currentSecion = line.replaceFirst("\\[(.*)]", "$1");
            this.current = new Properties();
            this.sections.put(this.currentSecion, this.current);
        } else if (line.matches(".*=.*") && this.current != null) {
            int i = line.indexOf(61);
            String name = line.substring(0, i).trim();
            String value = line.substring(i + 1).trim();
            this.current.setProperty(name, value);
        }
    }

    public String getValue(String section, String key) {
        Properties p = (Properties)this.sections.get(section);
        if (p == null) {
            return null;
        }
        String value = p.getProperty(key);
        return value;
    }
}

