/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MapUtils {
    public static Object getOrDefault(Map map, Object ... keys) throws ClassCastException {
        Object[] newKeys = new Object[keys.length - 1];
        for (int i = 0; i < newKeys.length; ++i) {
            newKeys[i] = keys[i];
        }
        Object value = MapUtils.getValue(map, newKeys);
        if (value == null) {
            return keys[keys.length - 1];
        }
        return value;
    }

    public static <T> T getOrDefault(Map map, Class<T> clazz, Object ... keys) throws ClassCastException {
        Object[] newKeys = new Object[keys.length - 1];
        for (int i = 0; i < newKeys.length; ++i) {
            newKeys[i] = keys[i];
        }
        T value = MapUtils.getValue(map, clazz, newKeys);
        if (value == null) {
            return (T)keys[keys.length - 1];
        }
        return value;
    }

    public static <T> T getValue(Map map, Class<T> clazz, Object ... keys) throws ClassCastException {
        Object value = MapUtils.getValue(map, keys);
        if (value == null) {
            return null;
        }
        if (!clazz.isInstance(value)) {
            return null;
        }
        return (T)value;
    }

    public static Object getValue(Map map, Object ... keys) throws ClassCastException {
        Map self = map;
        for (int i = 0; i < keys.length - 1; ++i) {
            Object key = keys[i];
            Object child = self.get(key);
            if (child == null) {
                return null;
            }
            if (!(child instanceof Map)) {
                return null;
            }
            self = (Map)child;
        }
        return self.get(keys[keys.length - 1]);
    }

    public static void setValue(Map map, Object ... keys) throws ClassCastException {
        Map self = map;
        for (int i = 0; i < keys.length - 2; ++i) {
            Object key = keys[i];
            AbstractMap child = (HashMap)self.get(key);
            if (child == null) {
                if (map instanceof HashMap) {
                    child = new HashMap();
                } else if (map instanceof ConcurrentHashMap) {
                    child = new ConcurrentHashMap();
                } else {
                    throw new ClassCastException("\u53ea\u652f\u6301:HashMap\u548cConcurrentHashMap\uff0c\u800c\u8f93\u5165\u7684\u662f" + map.getClass().getSimpleName());
                }
                self.put(key, child);
            }
            self = child;
        }
        self.put(keys[keys.length - 2], keys[keys.length - 1]);
    }

    public static void remove(Map map, Object ... keys) throws ClassCastException {
        Map self = map;
        for (int i = 0; i < keys.length - 1; ++i) {
            Object key = keys[i];
            Map child = (Map)self.get(key);
            if (child == null) {
                return;
            }
            self = child;
        }
        self.remove(keys[keys.length - 1]);
    }

    public static void setValue(Map map, Object[] path, Object value) throws ClassCastException {
        Map self = map;
        for (int i = 0; i < path.length; ++i) {
            Object key = path[i];
            Object child = self.get(key);
            if (i < path.length - 1) {
                if (child == null) {
                    if (map instanceof HashMap) {
                        child = new HashMap();
                    } else if (map instanceof ConcurrentHashMap) {
                        child = new ConcurrentHashMap();
                    } else {
                        throw new ClassCastException("\u53ea\u652f\u6301:HashMap\u548cConcurrentHashMap\uff0c\u800c\u8f93\u5165\u7684\u662f" + map.getClass().getSimpleName());
                    }
                    self.put(key, child);
                }
                self = (Map)child;
                continue;
            }
            self.put(key, value);
        }
    }

    public static void setDefaultValue(Map map, Object key, Object defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            map.put(key, defaultValue);
            return;
        }
    }

    public static void setDefaultValue(Map map, Object key, Class type, Object defaultValue) {
        Object value = map.get(key);
        if (value == null || !type.isInstance(value)) {
            map.put(key, defaultValue);
            return;
        }
    }

    public static void copyValue(Map<String, Object> data, String keyData, Map<String, Object> param, String keyParam, Object defaultValue) {
        Object value = param.get(keyParam);
        if (value == null) {
            value = defaultValue;
        }
        data.put(keyData, value);
    }

    public static Map castMap(Map map, Class mapType) throws ClassCastException, InstantiationException, IllegalAccessException {
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new ClassCastException();
        }
        Map node = (Map)mapType.newInstance();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                node.put(key, MapUtils.castMap((Map)value, mapType));
                continue;
            }
            if (value instanceof Collection) {
                Collection list = (Collection)value.getClass().newInstance();
                Collection vs = (Collection)value;
                for (Object v : vs) {
                    if (v instanceof Map) {
                        list.add(MapUtils.castMap((Map)v, mapType));
                        continue;
                    }
                    list.add(v);
                }
                node.put(key, list);
                continue;
            }
            node.put(key, value);
        }
        return node;
    }

    public static List castMap(List mapList, Class mapType) throws ClassCastException, InstantiationException, IllegalAccessException {
        ArrayList<Map> result = new ArrayList<Map>();
        for (Object map : mapList) {
            result.add(MapUtils.castMap((Map)map, mapType));
        }
        return result;
    }
}

