/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DifferUtils {
    public static <T> void differByValue(Collection<T> srcList, Collection<T> dstList, Collection<T> addList, Collection<T> delList, Collection<T> eqlList) {
        DifferUtils.differA2BByValue(srcList, dstList, addList, eqlList);
        DifferUtils.differA2BByValue(dstList, srcList, delList, eqlList);
    }

    private static <T> void differA2BByValue(Collection<T> srcList, Collection<T> dstList, Collection<T> addList, Collection<T> eqlList) {
        addList.clear();
        eqlList.clear();
        for (T aT : dstList) {
            boolean isexist = false;
            for (T bT : srcList) {
                if (!aT.equals(bT)) continue;
                isexist = true;
                break;
            }
            if (!isexist) {
                addList.add(aT);
                continue;
            }
            eqlList.add(aT);
        }
    }

    public static <T> boolean differByValue(Set<T> aList, Set<T> bList) {
        HashSet addList = new HashSet();
        HashSet delList = new HashSet();
        HashSet eqlList = new HashSet();
        DifferUtils.differByValue(aList, bList, addList, delList, eqlList);
        return !addList.isEmpty() || !delList.isEmpty();
    }

    public static <T> void differByValue(Set<T> srcList, Set<T> dstList, Set<T> addList, Set<T> delList, Set<T> eqlList) {
        DifferUtils.differA2BByValue(srcList, dstList, addList, eqlList);
        DifferUtils.differA2BByValue(dstList, srcList, delList, eqlList);
    }

    private static <T> void differA2BByValue(Set<T> srcList, Set<T> dstList, Set<T> addList, Set<T> eqlList) {
        for (T dstT : dstList) {
            if (null != dstT && srcList.contains(dstT)) {
                eqlList.add(dstT);
                continue;
            }
            addList.add(dstT);
        }
    }

    public static <T> boolean differA2BByConsistency(List<T> aList, List<T> bList) {
        int size = aList.size();
        if (bList.size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (aList.get(i).equals(bList.get(i))) continue;
            return false;
        }
        return true;
    }
}

