/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.utils.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.beans.BeanMap;

public class BeanMapUtils {
    public static Object mapToObject(Map<String, Object> map, Class<?> beanClass) throws Exception {
        Object object = beanClass.newInstance();
        BeanMap beanMap = BeanMap.create(object);
        beanMap.putAll(map);
        return object;
    }

    public static Map<String, Object> objectToMap(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj != null) {
            BeanMap beanMap = BeanMap.create((Object)obj);
            for (Object key : beanMap.keySet()) {
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> List<Map<String, Object>> objectToMap(Collection<T> objectList, List<String> filterKeys) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (T entity : objectList) {
            Map<String, Object> map = BeanMapUtils.objectToMap(entity);
            for (String filter : filterKeys) {
                map.remove(filter);
            }
            result.add(map);
        }
        return result;
    }

    public static <T> void filterKeys(List<Map<String, Object>> objectList, List<String> filterKeys) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : objectList) {
            for (String filter : filterKeys) {
                map.remove(filter);
            }
            result.add(map);
        }
    }

    public static <T> List<Map<String, Object>> objectToMap(Collection<T> objectList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (T entity : objectList) {
            Map<String, Object> map = BeanMapUtils.objectToMap(entity);
            result.add(map);
        }
        return result;
    }

    public static <T> Map<String, Object> objectToMap(T object, List<String> filterKeys) {
        Map<String, Object> map = BeanMapUtils.objectToMap(object);
        for (String filter : filterKeys) {
            map.remove(filter);
        }
        return map;
    }
}

