/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.process;

import cn.foxtech.common.utils.ContainerUtils;
import cn.foxtech.common.utils.MapUtils;
import cn.foxtech.common.utils.shell.ShellUtils;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcessUtils {
    public static void extendAppStatus(List<Map<String, Object>> serviceIniFileInfoList) throws IOException, InterruptedException {
        List<Map<String, Object>> processList = ProcessUtils.getProcess();
        Map pathName2ProcessStatus = ContainerUtils.buildMapByMapAt(processList, (String)"pathName", String.class);
        for (Map<String, Object> confFileInfo : serviceIniFileInfoList) {
            Map status;
            String pathName = (String)confFileInfo.get("pathName");
            if (pathName == null || pathName.isEmpty() || (status = (Map)pathName2ProcessStatus.get(pathName)) == null) continue;
            confFileInfo.putAll(status);
        }
    }

    public static List<Map<String, Object>> getProcess() throws IOException, InterruptedException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        resultList.addAll(ProcessUtils.getProcess("kernel"));
        resultList.addAll(ProcessUtils.getProcess("system"));
        resultList.addAll(ProcessUtils.getProcess("service"));
        return resultList;
    }

    public static List<Map<String, Object>> getProcess(String appType) throws IOException, InterruptedException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        File file = new File("");
        String path = file.getAbsolutePath() + "/bin/" + appType + "/";
        List shellLineList = ShellUtils.executeShell((String)("ps -aux|grep " + path));
        for (String shellLine : shellLineList) {
            String[] items = shellLine.split("\\s+");
            if (items.length < 14) continue;
            items = ProcessUtils.filterDebug(items);
            Map<String, Object> map = ProcessUtils.makeShellParam(items);
            String appEngine = items[10];
            if (!"java".equals(appEngine) && !"python".equals(appEngine) && !"python3".equals(appEngine)) continue;
            List<String> params = ProcessUtils.splitLinuxShellParam(items);
            Map<String, Object> foxParam = ProcessUtils.splitFoxEdgeParam(params, path);
            map.putAll(foxParam);
            map.put("appType", appType);
            map.put("appEngine", appEngine);
            resultList.add(map);
        }
        return resultList;
    }

    public static Map<String, Object> getSysProcess(String feature) throws IOException, InterruptedException {
        List shellLineList = ShellUtils.executeShell((String)("ps -aux|grep " + feature));
        for (String shellLine : shellLineList) {
            Map<String, Object> map;
            String command;
            String[] items = shellLine.split("\\s+");
            if (items.length < 11 || !(command = (String)(map = ProcessUtils.makeShellParam(items = ProcessUtils.filterDebug(items))).get("command")).endsWith(feature)) continue;
            return map;
        }
        return null;
    }

    public static Set<Long> getProcessPort(Long pid) throws IOException, InterruptedException {
        List shellLineList = ShellUtils.executeShell((String)("ss -tnlp | grep pid=" + pid));
        HashSet<Long> ports = new HashSet<Long>();
        for (String shellLine : shellLineList) {
            String[] items = shellLine.split("\\s+");
            if (items.length < 6 || (items = items[3].split(":")).length < 2) continue;
            ports.add(Long.parseLong(items[items.length - 1]));
        }
        return ports;
    }

    private static Map<String, Object> makeShellParam(String[] items) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user", items[0]);
        map.put("pid", Long.parseLong(items[1]));
        map.put("cpu", Double.parseDouble(items[2]));
        map.put("men", Double.parseDouble(items[3]));
        map.put("vsz", Long.parseLong(items[4]));
        map.put("rss", Long.parseLong(items[5]));
        map.put("stime", items[8]);
        map.put("time", items[9]);
        map.put("command", items[10]);
        return map;
    }

    private static Map<Long, Long> getLoaderPid() throws IOException, InterruptedException {
        File file = new File("");
        String path = file.getAbsolutePath() + "/bin/";
        List shellLineList = ShellUtils.executeShell((String)("ps -aux|grep " + path));
        HashMap infMap = new HashMap();
        for (String shellLine : shellLineList) {
            Map<String, Object> javaInf = ProcessUtils.findJavaInf(shellLine);
            if (javaInf != null) {
                MapUtils.setValue(infMap, (Object[])new Object[]{javaInf.get("pathName"), "fileName", javaInf.get("pid")});
                continue;
            }
            Map<String, Object> loadInf = ProcessUtils.findLoaderInf(shellLine);
            if (loadInf == null) continue;
            MapUtils.setValue(infMap, (Object[])new Object[]{loadInf.get("pathName"), "loaderName", loadInf.get("pid")});
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        for (String key : infMap.keySet()) {
            Map map = (Map)infMap.get(key);
            Long javaPid = (Long)MapUtils.getValue((Map)map, (Object[])new Object[]{"fileName"});
            Long loadPid = (Long)MapUtils.getValue((Map)map, (Object[])new Object[]{"loaderName"});
            if (javaPid == null || loadPid == null) continue;
            result.put(javaPid, loadPid);
        }
        return result;
    }

    private static Map<String, Object> findJavaInf(String shellLine) {
        String[] items = shellLine.split("\\s+");
        if (items.length < 14) {
            return null;
        }
        items = ProcessUtils.filterDebug(items);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pid", Long.parseLong(items[1]));
        if (!"java".equals(items[10])) {
            return null;
        }
        List<String> params = ProcessUtils.splitLinuxShellParam(items);
        String flag = "/opt/fox-edge/bin/";
        String pathName = ProcessUtils.findParam(params, flag);
        map.put("pathName", flag + pathName);
        return map;
    }

    private static Map<String, Object> findLoaderInf(String shellLine) {
        String[] items = shellLine.split("\\s+");
        if (items.length < 14) {
            return null;
        }
        items = ProcessUtils.filterDebug(items);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pid", Long.parseLong(items[1]));
        if ("java".equals(items[10])) {
            return null;
        }
        String flag = "/opt/fox-edge/bin/";
        if (!items[10].startsWith(flag)) {
            return null;
        }
        List<String> params = ProcessUtils.splitLinuxShellParam(items);
        String pathName = ProcessUtils.findParam(params, flag);
        map.put("pathName", flag + pathName);
        return map;
    }

    private static List<String> splitLinuxShellParam(String[] items) {
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 11; i < items.length; ++i) {
            params.add(items[i]);
        }
        return params;
    }

    private static Map<String, Object> splitFoxEdgeParam(List<String> params, String path) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (params.size() < 3) {
            return result;
        }
        String appNameAndFileName = ProcessUtils.findParam(params, path);
        if (appNameAndFileName != null) {
            String pathName = path + appNameAndFileName;
            result.put("pathName", pathName);
            String[] items = pathName.split("/");
            if (items.length > 0) {
                result.put("fileName", items[items.length - 1]);
            }
        }
        String appName = ProcessUtils.findParam(params, "--app_name=");
        String springRedisHost = ProcessUtils.findParam(params, "--spring.redis.host=");
        String springRedisPort = ProcessUtils.findParam(params, "--spring.redis.port=");
        String serverPort = ProcessUtils.findParam(params, "--server.port=");
        if (serverPort == null || serverPort.equals("")) {
            serverPort = ProcessUtils.findParam(params, "server.port=");
        }
        if (appName != null && !appName.isEmpty()) {
            result.put("appName", appName);
        }
        if (springRedisHost != null && !springRedisHost.isEmpty()) {
            result.put("redisHost", springRedisHost);
        }
        if (springRedisPort != null && !springRedisPort.isEmpty()) {
            result.put("redisPort", springRedisPort);
        }
        if (serverPort != null && !serverPort.isEmpty()) {
            try {
                Integer appPort = Integer.parseInt(serverPort);
                result.put("appPort", appPort);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static String findParam(List<String> shellParams, String springHeader) {
        for (String shellParam : shellParams) {
            if (!shellParam.startsWith(springHeader)) continue;
            return shellParam.substring(springHeader.length());
        }
        return null;
    }

    public static List<String> gcProcess(Long pid) throws IOException, InterruptedException {
        return ShellUtils.executeShell((String)("jmap -histo:live " + pid + " | head -10"));
    }

    private static String[] filterDebug(String[] items) {
        ArrayList<String> list = new ArrayList<String>();
        for (String item : items) {
            if (item.startsWith("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=")) continue;
            list.add(item);
        }
        return list.toArray(new String[list.size()]);
    }

    public static Long findPidByPort(Integer appPort) throws IOException, InterruptedException {
        List shellLineList = ShellUtils.executeShell((String)("netstat -anp | grep " + appPort));
        for (String shellLine : shellLineList) {
            String[] pidItems;
            String[] items = shellLine.split("\\s+");
            if (items.length != 7) continue;
            String ipAndPort = items[3];
            String pidAndCmd = items[6];
            String[] portItems = ipAndPort.split(":");
            if (portItems.length <= 0 || !portItems[portItems.length - 1].equals(appPort.toString()) || (pidItems = pidAndCmd.split("/")).length <= 0) continue;
            try {
                return Long.parseLong(pidItems[0]);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static final long getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return Long.valueOf(runtimeMXBean.getName().split("@")[0]);
    }

    public static boolean killLoader() {
        try {
            String OS = System.getProperty("os.name").toLowerCase();
            if (OS.indexOf("linux") < 0) {
                return false;
            }
            Map<Long, Long> jar2loader = ProcessUtils.getLoaderPid();
            if (jar2loader == null || jar2loader.isEmpty()) {
                return false;
            }
            Long jarPid = ProcessUtils.getProcessID();
            Long loaderPid = jar2loader.get(jarPid);
            if (loaderPid == null) {
                return false;
            }
            ShellUtils.executeShell((String)("kill -9 " + loaderPid));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

