/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.mqtt;

import cn.foxtech.common.utils.MapUtils;
import java.util.Map;
import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
public class MqttConfigService {
    private final String subscribe = "/fox/proxy/c2e";
    private String host = "127.0.0.1";
    private Integer port = 1883;
    private String userName = "mica";
    private String password = "123456";
    private String name = "Mica-Mqtt-Client";
    private String version = "mqtt_3_1_1";
    private String clientId = "FOX_CLIENT_CHANNEL_MQTT_CLIENT";
    private Integer keepAliveSecs = 60;
    private Integer reInterval = 5000;

    public void initialize(Map<String, Object> configs) {
        this.host = (String)MapUtils.getOrDefault(configs, String.class, (Object[])new Object[]{"host", this.host});
        this.port = (Integer)MapUtils.getOrDefault(configs, Integer.class, (Object[])new Object[]{"port", this.port});
        this.clientId = (String)MapUtils.getOrDefault(configs, String.class, (Object[])new Object[]{"clientId", this.clientId});
        this.userName = (String)MapUtils.getOrDefault(configs, String.class, (Object[])new Object[]{"user-name", this.userName});
        this.password = (String)MapUtils.getOrDefault(configs, String.class, (Object[])new Object[]{"password", this.password});
        this.name = (String)MapUtils.getOrDefault(configs, String.class, (Object[])new Object[]{"name", this.name});
        this.version = (String)MapUtils.getOrDefault(configs, String.class, (Object[])new Object[]{"version", this.version});
        this.keepAliveSecs = (Integer)MapUtils.getOrDefault(configs, Integer.class, (Object[])new Object[]{"keep-alive-secs", this.keepAliveSecs});
        this.reInterval = (Integer)MapUtils.getOrDefault(configs, Integer.class, (Object[])new Object[]{"re-interval", this.reInterval});
        if (this.clientId == null || this.clientId.isEmpty()) {
            this.clientId = "clientId:" + UUID.randomUUID();
        }
    }

    public String getSubscribe() {
        return this.subscribe;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Integer getKeepAliveSecs() {
        return this.keepAliveSecs;
    }

    public Integer getReInterval() {
        return this.reInterval;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setKeepAliveSecs(Integer keepAliveSecs) {
        this.keepAliveSecs = keepAliveSecs;
    }

    public void setReInterval(Integer reInterval) {
        this.reInterval = reInterval;
    }
}

