/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.service.redis.RedisReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisReaderService {
    private static final Map<String, RedisReader> map = new ConcurrentHashMap<String, RedisReader>();

    public static synchronized <T> RedisReader newInstance(Class<T> clazz, RedisTemplate redisTemplate) {
        RedisReader instance = new RedisReader();
        instance.setEntityType(clazz.getSimpleName());
        instance.setRedisTemplate(redisTemplate);
        return instance;
    }

    public static synchronized <T> RedisReader getInstanceBySimpleName(String clazzSimpleName, RedisTemplate redisTemplate) {
        if (map.containsKey(clazzSimpleName)) {
            return map.get(clazzSimpleName);
        }
        RedisReader instance = new RedisReader();
        instance.setEntityType(clazzSimpleName);
        instance.setRedisTemplate(redisTemplate);
        map.put(instance.getEntityType(), instance);
        return map.get(clazzSimpleName);
    }

    public static <T> RedisReader getInstance(Class<T> clazz, RedisTemplate redisTemplate) {
        return RedisReaderService.getInstanceBySimpleName(clazz.getSimpleName(), redisTemplate);
    }
}

