/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.service.redis.BaseEntityClassFactory;
import cn.foxtech.common.entity.service.redis.IBaseFinder;
import cn.foxtech.common.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisReader {
    private RedisTemplate redisTemplate;
    private String entityType;

    private String getHead() {
        return "fox.edge.entity." + this.getEntityType() + ".";
    }

    public Map<String, Object> readAgileMap() {
        return this.redisTemplate.opsForHash().entries((Object)(this.getHead() + "agile"));
    }

    public Object readSync() {
        return this.redisTemplate.opsForValue().get((Object)(this.getHead() + "sync"));
    }

    public Map<String, Object> readHashMap() {
        Map map = this.redisTemplate.opsForHash().entries((Object)(this.getHead() + "data"));
        return map;
    }

    public List<BaseEntity> readEntityList() throws InstantiationException, IllegalAccessException {
        Class clazz = BaseEntityClassFactory.getInstance(this.getEntityType());
        ArrayList<BaseEntity> entityList = new ArrayList<BaseEntity>();
        BaseEntity builder = (BaseEntity)clazz.newInstance();
        List<Map<String, Object>> mapList = this.readHashMapList();
        for (Map<String, Object> map : mapList) {
            BaseEntity entity = builder.build(map);
            if (entity == null) continue;
            entityList.add(entity);
        }
        Collections.sort(entityList, (o1, o2) -> {
            Long id2 = o2.getId() == null ? 0L : o2.getId();
            Long id1 = o1.getId() == null ? 0L : o1.getId();
            return id1.compareTo(id2);
        });
        return entityList;
    }

    public List<Map<String, Object>> readHashMapList() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map<String, Object> dataRds = this.readHashMap();
        for (Object data : dataRds.values()) {
            if (data == null || !(data instanceof Map)) continue;
            result.add((Map)data);
        }
        return result;
    }

    public Map<String, BaseEntity> readEntityMap(Collection hKeys) throws InstantiationException, IllegalAccessException {
        List mapList = this.redisTemplate.opsForHash().multiGet((Object)(this.getHead() + "data"), hKeys);
        return this.makeHashMap2EntityList(mapList);
    }

    public BaseEntity readEntity(String serviceKey) throws IOException {
        Class clazz = BaseEntityClassFactory.getInstance(this.getEntityType());
        Map dataJsn = (Map)this.redisTemplate.opsForHash().get((Object)(this.getHead() + "data"), (Object)serviceKey);
        return this.makeJson2Entity(clazz, dataJsn);
    }

    public Map<String, Object> readHashMap(String serviceKey) {
        return (Map)this.redisTemplate.opsForHash().get((Object)(this.getHead() + "data"), (Object)serviceKey);
    }

    private BaseEntity makeJson2Entity(Class clazz, Map<String, Object> jsonObject) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsn = objectMapper.writeValueAsString(jsonObject);
        BaseEntity entity = (BaseEntity)objectMapper.readValue(jsn, clazz);
        return entity;
    }

    private Map<String, BaseEntity> makeJson2EntityList(List<Object> jsonList) throws JsonParseException {
        Class clazz = BaseEntityClassFactory.getInstance(this.getEntityType());
        ConcurrentHashMap<String, BaseEntity> result = new ConcurrentHashMap<String, BaseEntity>();
        for (Object json : jsonList) {
            Map jsonObject = (Map)json;
            if (jsonObject == null) continue;
            BaseEntity entity = (BaseEntity)JsonUtils.buildObject((Map)jsonObject, (Class)clazz);
            result.put(entity.makeServiceKey(), entity);
        }
        return result;
    }

    private Map<String, BaseEntity> makeHashMap2EntityList(Collection<Object> jsonList) throws InstantiationException, IllegalAccessException {
        Class clazz = BaseEntityClassFactory.getInstance(this.getEntityType());
        BaseEntity builder = (BaseEntity)clazz.newInstance();
        ConcurrentHashMap<String, BaseEntity> result = new ConcurrentHashMap<String, BaseEntity>();
        for (Object obj : jsonList) {
            BaseEntity entity;
            Map map = (Map)obj;
            if (map == null || (entity = builder.build(map)) == null) continue;
            result.put(entity.makeServiceKey(), entity);
        }
        return result;
    }

    public <T> List<BaseEntity> readEntityList(IBaseFinder finder) throws InstantiationException, IllegalAccessException {
        ArrayList<BaseEntity> entityList = new ArrayList<BaseEntity>();
        Class clazz = BaseEntityClassFactory.getInstance(this.getEntityType());
        BaseEntity builder = (BaseEntity)clazz.newInstance();
        List<Map<String, Object>> mapList = this.readHashMapList();
        for (Map<String, Object> map : mapList) {
            BaseEntity entity = builder.build(map);
            if (!finder.compareValue(entity)) continue;
            entityList.add(entity);
        }
        Collections.sort(entityList, (o1, o2) -> {
            Long id2 = o2.getId() == null ? 0L : o2.getId();
            Long id1 = o1.getId() == null ? 0L : o1.getId();
            return id1.compareTo(id2);
        });
        return entityList;
    }

    public <T> T readEntity(IBaseFinder finder) throws InstantiationException, IllegalAccessException {
        Class clazz = BaseEntityClassFactory.getInstance(this.getEntityType());
        BaseEntity builder = (BaseEntity)clazz.newInstance();
        List<Map<String, Object>> mapList = this.readHashMapList();
        for (Map<String, Object> map : mapList) {
            BaseEntity entity = builder.build(map);
            if (!finder.compareValue(entity)) continue;
            return (T)entity;
        }
        return null;
    }

    public <T> int getEntityCount(IBaseFinder finder) throws InstantiationException, IllegalAccessException {
        Class clazz = BaseEntityClassFactory.getInstance(this.getEntityType());
        BaseEntity builder = (BaseEntity)clazz.newInstance();
        int count = 0;
        List<Map<String, Object>> mapList = this.readHashMapList();
        for (Map<String, Object> map : mapList) {
            BaseEntity entity = builder.build(map);
            if (!finder.compareValue(entity)) continue;
            ++count;
        }
        return count;
    }

    public <T> T readEntity(Long id) throws InstantiationException, IllegalAccessException {
        return this.readEntity((Object value) -> {
            BaseEntity entity = (BaseEntity)value;
            return id.equals(entity.getId());
        });
    }

    public <T> T readEntity(String serviceKey, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        Map<String, Object> map = this.readHashMap(serviceKey);
        if (map == null) {
            return null;
        }
        BaseEntity builder = (BaseEntity)clazz.newInstance();
        return (T)builder.build(map);
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }
}

