/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.service.redis.BaseConsumerRedisService;
import cn.foxtech.utils.common.utils.redis.service.RedisService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConsumerRedisService
extends BaseConsumerRedisService {
    private static final Map<String, ConsumerRedisService> map = new ConcurrentHashMap<String, ConsumerRedisService>();
    private String entityType;
    private RedisService redisService;

    public static synchronized <T> ConsumerRedisService newInstance(Class<T> clazz, RedisService redisService) {
        ConsumerRedisService instance = new ConsumerRedisService();
        instance.entityType = clazz.getSimpleName();
        instance.redisService = redisService;
        return instance;
    }

    public static synchronized <T> ConsumerRedisService getInstanceBySimpleName(String clazzSimpleName, RedisService redisService) {
        if (map.containsKey(clazzSimpleName)) {
            return map.get(clazzSimpleName);
        }
        ConsumerRedisService instance = new ConsumerRedisService();
        instance.entityType = clazzSimpleName;
        instance.redisService = redisService;
        map.put(instance.entityType, instance);
        return map.get(clazzSimpleName);
    }

    public static <T> ConsumerRedisService getInstance(Class<T> clazz, RedisService redisService) {
        return ConsumerRedisService.getInstanceBySimpleName(clazz.getSimpleName(), redisService);
    }

    @Override
    public RedisService getRedisService() {
        return this.redisService;
    }

    @Override
    public String getEntityType() {
        return this.entityType;
    }
}

