/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.service.redis.BaseConsumerEntityNotify;
import cn.foxtech.common.entity.service.redis.BaseConsumerTypeNotify;
import cn.foxtech.common.entity.service.redis.BaseEntityClassFactory;
import cn.foxtech.common.entity.service.redis.IBaseFinder;
import cn.foxtech.common.utils.DifferUtils;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.utils.common.utils.redis.service.RedisService;
import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class BaseRedisService {
    private final List<BaseConsumerEntityNotify> entityNotify = new CopyOnWriteArrayList<BaseConsumerEntityNotify>();
    private Map<String, BaseEntity> dataMap = new ConcurrentHashMap<String, BaseEntity>();
    private Map<String, Long> agileMap = new ConcurrentHashMap<String, Long>();
    private Long updateTime = 0L;
    private boolean needSave = false;
    private boolean inited = false;
    private BaseConsumerTypeNotify typeNotify = null;

    public abstract RedisService getRedisService();

    public abstract String getEntityType();

    public boolean isInited() {
        return this.inited;
    }

    public void setInited() {
        this.inited = true;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    protected void bind(BaseConsumerTypeNotify notify) {
        this.typeNotify = notify;
    }

    protected List<BaseConsumerEntityNotify> getEntityNotify() {
        return this.entityNotify;
    }

    protected String getHead() {
        return "fox.edge.entity." + this.getEntityType() + ".";
    }

    protected void loadAllEntities() throws JsonParseException {
        this.updateTime = (Long)this.getRedisService().getCacheObject(this.getHead() + "sync");
        if (this.updateTime == null) {
            this.updateTime = 0L;
        }
        this.agileMap = this.getRedisService().getCacheMap(this.getHead() + "agile");
        Map jsonMap = this.getRedisService().getCacheMap(this.getHead() + "data");
        this.dataMap = this.makeJson2EntityMap(jsonMap);
    }

    private Map<String, BaseEntity> makeJson2EntityMap(Map<String, Object> jsonMap) throws JsonParseException {
        Class entityClass = BaseEntityClassFactory.getInstance(this.getEntityType());
        ConcurrentHashMap<String, BaseEntity> result = new ConcurrentHashMap<String, BaseEntity>();
        for (Map.Entry<String, Object> entry : jsonMap.entrySet()) {
            Map jsonObject = (Map)entry.getValue();
            BaseEntity entity = (BaseEntity)JsonUtils.buildObject((Map)jsonObject, (Class)entityClass);
            result.put(entry.getKey(), entity);
        }
        return result;
    }

    protected void loadAgileEntities() throws IOException {
        this.updateTime = (Long)this.getRedisService().getCacheObject(this.getHead() + "sync");
        Map newUpdateTimes = this.getRedisService().getCacheMap(this.getHead() + "agile");
        HashSet<String> addList = new HashSet<String>();
        HashSet<String> delList = new HashSet<String>();
        HashSet eqlList = new HashSet();
        DifferUtils.differByValue(this.agileMap.keySet(), newUpdateTimes.keySet(), addList, delList, eqlList);
        Map<String, Long> diff = this.compare(this.agileMap, newUpdateTimes);
        if (!addList.isEmpty() || !delList.isEmpty()) {
            this.loadAllEntities();
        } else if (diff.size() * 10 > this.agileMap.size() || diff.size() > 64) {
            this.loadAllEntities();
        } else {
            Class entityClass = BaseEntityClassFactory.getInstance(this.getEntityType());
            for (Map.Entry<String, Long> entry : diff.entrySet()) {
                Map jsonObject = (Map)this.getRedisService().getCacheMapValue(this.getHead() + "data", entry.getKey());
                BaseEntity redisEntity = (BaseEntity)JsonUtils.buildObjectWithoutException((Object)jsonObject, (Class)entityClass);
                Long agile = (Long)newUpdateTimes.get(entry.getKey());
                this.dataMap.put(entry.getKey(), redisEntity);
                this.agileMap.put(entry.getKey(), agile);
            }
        }
        this.notifyType(addList, delList, diff);
        this.notifyEntity(addList, delList, diff);
    }

    private void notifyEntity(Set<String> addList, Set<String> delList, Map<String, Long> diff) {
        if (this.entityNotify.isEmpty()) {
            return;
        }
        for (BaseConsumerEntityNotify notify : this.entityNotify) {
            String key = notify.getServiceKey();
            BaseEntity entity = this.dataMap.get(key);
            if (addList.contains(key)) {
                notify.notifyInsert(entity);
                continue;
            }
            if (diff.containsKey(key)) {
                notify.notifyUpdate(entity);
                continue;
            }
            if (!delList.contains(key)) continue;
            notify.notifyDelete(key);
        }
    }

    private void notifyType(Set<String> addList, Set<String> delList, Map<String, Long> diff) {
        if (this.typeNotify == null) {
            return;
        }
        HashMap<String, BaseEntity> addMap = new HashMap<String, BaseEntity>();
        HashMap<String, BaseEntity> mdyMap = new HashMap<String, BaseEntity>();
        for (String key : addList) {
            addMap.put(key, this.dataMap.get(key));
        }
        for (String key : diff.keySet()) {
            mdyMap.put(key, this.dataMap.get(key));
        }
        if (addMap.isEmpty() && delList.isEmpty() && mdyMap.isEmpty()) {
            return;
        }
        this.typeNotify.notify(this.getEntityType(), this.updateTime, addMap, delList, mdyMap);
    }

    private <T> void saveAllEntities(String mainKey, Map<String, T> cacheMap) {
        this.getRedisService().setCacheMap(mainKey, cacheMap);
        Map redisRedis = this.getRedisService().getCacheMap(mainKey);
        HashSet add = new HashSet();
        HashSet del = new HashSet();
        HashSet eql = new HashSet();
        DifferUtils.differByValue(redisRedis.keySet(), cacheMap.keySet(), add, del, eql);
        for (String hashKey : del) {
            this.getRedisService().deleteCacheMap(mainKey, hashKey);
        }
    }

    protected void saveAllEntities() {
        this.saveAllEntities(this.getHead() + "agile", this.agileMap);
        this.saveAllEntities(this.getHead() + "data", this.dataMap);
        this.updateTime = System.currentTimeMillis();
        this.getRedisService().setCacheObject(this.getHead() + "sync", (Object)this.updateTime);
        this.needSave = false;
    }

    private Map<String, Long> compare(Map<String, Long> newDatas, Map<String, Long> oldDatas) {
        ConcurrentHashMap<String, Long> diff = new ConcurrentHashMap<String, Long>();
        if (newDatas.size() != oldDatas.size()) {
            return diff;
        }
        for (Map.Entry<String, Long> entry : newDatas.entrySet()) {
            Long oldValue;
            Long newValue = entry.getValue();
            if (newValue.equals(oldValue = oldDatas.get(entry.getKey()))) continue;
            diff.put(entry.getKey(), entry.getValue());
        }
        return diff;
    }

    protected void saveAgileEntities() {
        Long time = System.currentTimeMillis();
        Map oldUpdateTimes = this.getRedisService().getCacheMap(this.getHead() + "agile");
        if (DifferUtils.differByValue(oldUpdateTimes.keySet(), this.agileMap.keySet())) {
            this.saveAllEntities();
        } else {
            Map<String, Long> diff = this.compare(this.agileMap, oldUpdateTimes);
            if (diff.size() * 10 > this.agileMap.size() || diff.size() > 64) {
                this.saveAllEntities();
            } else {
                for (Map.Entry<String, Long> entry : diff.entrySet()) {
                    this.getRedisService().setCacheMapValue(this.getHead() + "data", entry.getKey(), (Object)this.dataMap.get(entry.getKey()));
                    this.getRedisService().setCacheMapValue(this.getHead() + "agile", entry.getKey(), (Object)time);
                    this.agileMap.put(entry.getKey(), time);
                }
                String entitiesSyncKey = this.getHead() + "sync";
                this.updateTime = time;
                this.getRedisService().setCacheObject(entitiesSyncKey, (Object)this.updateTime);
                this.needSave = false;
            }
        }
    }

    protected void cleanAgileEntities() {
        this.getRedisService().deleteObject(this.getHead() + "agile");
        this.getRedisService().deleteObject(this.getHead() + "data");
        this.getRedisService().deleteObject(this.getHead() + "sync");
    }

    protected boolean isNeedLoad() {
        Long updateTime = (Long)this.getRedisService().getCacheObject(this.getHead() + "sync");
        if (updateTime == null) {
            return false;
        }
        return !this.updateTime.equals(updateTime);
    }

    protected boolean isNeedSave() {
        return this.needSave;
    }

    protected Map<String, BaseEntity> getEntitys() {
        return new ConcurrentHashMap<String, BaseEntity>(this.dataMap);
    }

    protected BaseEntity getEntity(String entityKey) {
        return this.dataMap.get(entityKey);
    }

    protected Map<String, BaseEntity> getEntityMap(Collection<String> entityKeys) {
        HashMap<String, BaseEntity> entityMap = new HashMap<String, BaseEntity>();
        for (String entityKey : entityKeys) {
            BaseEntity entity = this.dataMap.get(entityKey);
            if (entity == null) continue;
            entityMap.put(entityKey, entity);
        }
        return entityMap;
    }

    public List<BaseEntity> getEntityList() {
        ArrayList<BaseEntity> entityList = new ArrayList<BaseEntity>();
        for (Map.Entry<String, BaseEntity> operateEntry : this.dataMap.entrySet()) {
            entityList.add(operateEntry.getValue());
        }
        return entityList;
    }

    public void foreachFinder(IBaseFinder finder) {
        ArrayList<BaseEntity> entityList = new ArrayList<BaseEntity>();
        for (Map.Entry<String, BaseEntity> operateEntry : this.dataMap.entrySet()) {
            if (!finder.compareValue(operateEntry.getValue())) continue;
            entityList.add(operateEntry.getValue());
        }
    }

    public List<BaseEntity> getEntityList(IBaseFinder finder) {
        ArrayList<BaseEntity> entityList = new ArrayList<BaseEntity>();
        for (Map.Entry<String, BaseEntity> entry : this.dataMap.entrySet()) {
            if (!finder.compareValue(entry.getValue())) continue;
            entityList.add(entry.getValue());
        }
        return entityList;
    }

    public BaseEntity getEntity(IBaseFinder finder) {
        for (Map.Entry<String, BaseEntity> entry : this.dataMap.entrySet()) {
            if (!finder.compareValue(entry.getValue())) continue;
            return entry.getValue();
        }
        return null;
    }

    public int getEntityCount(IBaseFinder finder) {
        int count = 0;
        for (Map.Entry<String, BaseEntity> entry : this.dataMap.entrySet()) {
            if (!finder.compareValue(entry.getValue())) continue;
            ++count;
        }
        return count;
    }

    public BaseEntity getEntity(Long id) {
        for (Map.Entry<String, BaseEntity> entry : this.dataMap.entrySet()) {
            if (!id.equals(entry.getValue().getId())) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    protected void insertEntity(BaseEntity entity) {
        this.putEntity(entity);
    }

    protected BaseEntity selectEntity(BaseEntity entity) {
        return this.getEntity(entity.makeServiceKey());
    }

    protected void updateEntity(BaseEntity entity) {
        String entityKey = entity.makeServiceKey();
        BaseEntity existEntity = this.dataMap.get(entityKey);
        if (existEntity == null) {
            return;
        }
        this.putEntity(entity);
    }

    protected void deleteEntity(String entityKey) {
        BaseEntity existEntity = this.getEntitys().get(entityKey);
        if (existEntity == null) {
            return;
        }
        this.removeEntity(entityKey);
        this.agileMap.remove(entityKey);
        this.needSave = true;
    }

    protected void setDataMap(List<BaseEntity> dataMap) {
        this.dataMap = new ConcurrentHashMap<String, BaseEntity>();
        for (BaseEntity entity : dataMap) {
            this.dataMap.put(entity.makeServiceKey(), entity);
        }
        Long updateTime = System.currentTimeMillis();
        this.agileMap = new ConcurrentHashMap<String, Long>();
        for (BaseEntity entity : dataMap) {
            this.agileMap.put(entity.makeServiceKey(), updateTime);
        }
        this.needSave = true;
    }

    private void putEntity(BaseEntity entity) {
        this.dataMap.put(entity.makeServiceKey(), entity);
        this.agileMap.put(entity.makeServiceKey(), System.currentTimeMillis());
        this.needSave = true;
    }

    private void removeEntity(String serviceKey) {
        this.dataMap.remove(serviceKey);
        this.agileMap.remove(serviceKey);
        this.needSave = true;
    }
}

