/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.utils.reflect.JarLoaderUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BaseEntityClassFactory {
    private static final Map<String, Class> map = new ConcurrentHashMap<String, Class>();

    public static synchronized Class getInstance(String entityType) {
        if (map.isEmpty()) {
            Map<String, Class> clazzMap = BaseEntityClassFactory.scan();
            map.putAll(clazzMap);
        }
        return map.get(entityType);
    }

    private static Map<String, Class> scan() {
        String packName = BaseEntity.class.getPackage().getName();
        HashMap<String, Class> result = new HashMap<String, Class>();
        Set classSet = JarLoaderUtils.getClasses((String)packName);
        for (Class clazz : classSet) {
            if (BaseEntity.class.equals((Object)clazz) || !BaseEntity.class.isAssignableFrom(clazz)) continue;
            result.put(clazz.getSimpleName(), clazz);
        }
        return result;
    }
}

