/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.service.redis.BaseAgileMapRedisService;
import cn.foxtech.utils.common.utils.redis.service.RedisService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AgileMapRedisService
extends BaseAgileMapRedisService {
    private static final Map<String, AgileMapRedisService> map = new ConcurrentHashMap<String, AgileMapRedisService>();
    private String entityType;
    private RedisService redisService;

    public static synchronized <T> AgileMapRedisService newInstance(Class<T> clazz, RedisService redisService) {
        AgileMapRedisService instance = new AgileMapRedisService();
        instance.entityType = clazz.getSimpleName();
        instance.redisService = redisService;
        return instance;
    }

    public static synchronized <T> AgileMapRedisService getInstanceBySimpleName(String clazzSimpleName, RedisService redisService) {
        if (map.containsKey(clazzSimpleName)) {
            return map.get(clazzSimpleName);
        }
        AgileMapRedisService instance = new AgileMapRedisService();
        instance.entityType = clazzSimpleName;
        instance.redisService = redisService;
        map.put(instance.entityType, instance);
        return map.get(clazzSimpleName);
    }

    public static <T> AgileMapRedisService getInstance(Class<T> clazz, RedisService redisService) {
        return AgileMapRedisService.getInstanceBySimpleName(clazz.getSimpleName(), redisService);
    }

    @Override
    public RedisService getRedisService() {
        return this.redisService;
    }

    @Override
    public String getEntityType() {
        return this.entityType;
    }
}

