/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.mybatis;

import cn.foxtech.common.entity.entity.BaseEntity;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseCacheService {
    protected BaseMapper mapper = null;
    private Map<String, BaseEntity> entitys = null;

    public abstract void bindMapper();

    public void insertEntity(BaseEntity entity) {
        Long time = System.currentTimeMillis();
        entity.setCreateTime(time);
        entity.setUpdateTime(time);
        this.mapper.insert((Object)entity);
        this.getEntitys().put(entity.makeServiceKey(), entity);
    }

    public BaseEntity selectEntity(BaseEntity entity) {
        return this.getEntity(entity.makeServiceKey());
    }

    public void updateEntity(BaseEntity entity) {
        String entityKey = entity.makeServiceKey();
        BaseEntity existEntity = this.getEntitys().get(entityKey);
        if (existEntity == null) {
            return;
        }
        if (existEntity.makeServiceValue().equals(entity.makeServiceValue())) {
            return;
        }
        entity.setId(existEntity.getId());
        entity.setCreateTime(existEntity.getCreateTime());
        entity.setUpdateTime(System.currentTimeMillis());
        this.mapper.update((Object)entity, (Wrapper)((QueryWrapper)entity.makeWrapperKey()));
        this.getEntitys().put(entityKey, entity);
    }

    public void deleteEntity(BaseEntity entity) {
        String entityKey = entity.makeServiceKey();
        BaseEntity existEntity = this.getEntitys().get(entityKey);
        if (existEntity == null) {
            return;
        }
        this.mapper.deleteById((Serializable)existEntity);
        this.getEntitys().remove(entityKey);
    }

    public void instance() {
        if (this.entitys != null) {
            return;
        }
        this.bindMapper();
        this.loadEntitys();
    }

    public void loadEntitys() {
        HashMap<String, BaseEntity> resultEntitys = new HashMap<String, BaseEntity>();
        List entitys = this.mapper.selectList(null);
        for (BaseEntity entity : entitys) {
            String entityKey = entity.makeServiceKey();
            resultEntitys.put(entityKey, entity);
        }
        this.entitys = resultEntitys;
    }

    public Map<String, BaseEntity> getEntitys() {
        this.instance();
        return this.entitys;
    }

    public BaseEntity getEntity(String entityKey) {
        this.instance();
        if (!this.entitys.containsKey(entityKey)) {
            return null;
        }
        return this.entitys.get(entityKey);
    }

    public List<BaseEntity> getEntityList() {
        this.instance();
        ArrayList<BaseEntity> entitieList = new ArrayList<BaseEntity>();
        for (Map.Entry<String, BaseEntity> operateEntry : this.entitys.entrySet()) {
            entitieList.add(operateEntry.getValue());
        }
        return entitieList;
    }
}

