/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.entity;

import cn.foxtech.common.utils.number.NumberUtils;
import cn.foxtech.core.exception.ServiceException;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId(value="id", type=IdType.AUTO)
    private Long id;
    @TableField(value="create_time", fill=FieldFill.INSERT)
    private Long createTime;
    @TableField(value="update_time", fill=FieldFill.INSERT_UPDATE)
    private Long updateTime;

    public String makeServiceKey() {
        return this.makeServiceKeyList().toString();
    }

    public abstract List<Object> makeServiceKeyList();

    public boolean hasNullServiceKey() {
        List<Object> keys = this.makeServiceKeyList();
        for (Object key : keys) {
            if (key != null) continue;
            return true;
        }
        return false;
    }

    public String makeServiceValue() {
        return this.makeServiceValueList().toString();
    }

    public abstract List<Object> makeServiceValueList();

    public abstract Object makeWrapperKey();

    public BaseEntity build(Map<String, Object> map) {
        throw new ServiceException(this.getClass().getSimpleName() + "\u672a\u91cd\u8f7dBaseEntity build(Map<String,Object> map)\u51fd\u6570");
    }

    public void bind(Map<String, Object> map) {
        this.setId(NumberUtils.makeLong((Object)map.get("id")));
        this.setCreateTime(NumberUtils.makeLong((Object)map.get("createTime")));
        this.setUpdateTime(NumberUtils.makeLong((Object)map.get("updateTime")));
    }

    public void bind(BaseEntity other) {
        this.setId(other.getId());
        this.setCreateTime(other.getCreateTime());
        this.setUpdateTime(other.getUpdateTime());
    }

    private boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && a.equals(b);
    }

    public Long getId() {
        return this.id;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }
}

