/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.utils;

import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.service.mybatis.BaseEntityService;
import cn.foxtech.common.entity.service.redis.AgileMapRedisService;
import cn.foxtech.common.entity.service.redis.BaseConsumerRedisService;
import cn.foxtech.common.entity.service.redis.BaseProducerRedisService;
import cn.foxtech.common.entity.service.redis.BaseRedisService;
import cn.foxtech.common.entity.service.redis.HashMapRedisService;
import java.util.List;
import org.springframework.data.redis.serializer.SerializationException;

public class EntityServiceUtils {
    public static void initLoadEntity(BaseProducerRedisService redisService, BaseEntityService entityService) {
        try {
            if (!redisService.isInited()) {
                List<BaseEntity> entityList = entityService.selectEntityList();
                redisService.setDataMap(entityList);
                redisService.setInited();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initLoadEntity(BaseProducerRedisService redisService, BaseRedisService otherRedisService) {
        try {
            if (!redisService.isInited()) {
                List<BaseEntity> entityList = otherRedisService.getEntityList();
                redisService.setDataMap(entityList);
                redisService.setInited();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initLoadEntity(BaseProducerRedisService redisService, List<BaseEntity> initEntityList) {
        try {
            if (!redisService.isInited()) {
                redisService.setDataMap(initEntityList);
                redisService.setInited();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean publishEntity(BaseProducerRedisService redisService) {
        try {
            if (redisService.isNeedSave()) {
                redisService.saveAgileEntities();
                return true;
            }
        }
        catch (SerializationException se) {
            try {
                redisService.cleanAgileEntities();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean reloadRedis(BaseConsumerRedisService redisService) {
        try {
            boolean reloaded = false;
            if (redisService.isNeedLoad()) {
                redisService.loadAgileEntities();
                reloaded = true;
            }
            redisService.setInited();
            return reloaded;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean reloadRedis(HashMapRedisService redisService) {
        try {
            boolean reloaded = false;
            if (redisService.isNeedLoad()) {
                redisService.loadAgileEntities();
                reloaded = true;
            }
            redisService.setInited();
            return reloaded;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean reloadRedis(AgileMapRedisService redisService) {
        try {
            boolean reloaded = false;
            if (redisService.isNeedLoad()) {
                redisService.loadAgileEntities();
                reloaded = true;
            }
            redisService.setInited();
            return reloaded;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void insertEntity(BaseEntityService entityService, BaseProducerRedisService redisService, BaseEntity baseEntity) {
        entityService.insertEntity(baseEntity);
        redisService.insertEntity(baseEntity);
    }

    public static void deleteEntity(BaseEntityService entityService, BaseProducerRedisService redisService, BaseEntity baseEntity) {
        entityService.deleteEntity(baseEntity);
        redisService.deleteEntity(baseEntity.makeServiceKey());
    }

    public static void updateEntity(BaseEntityService entityService, BaseProducerRedisService redisService, BaseEntity baseEntity) {
        entityService.updateEntity(baseEntity);
        redisService.updateEntity(baseEntity);
    }
}

