/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.service.redis.RedisWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisWriterService {
    private static final Map<String, RedisWriter> map = new ConcurrentHashMap<String, RedisWriter>();

    public static synchronized <T> RedisWriter newInstance(Class<T> clazz, RedisTemplate redisTemplate) {
        RedisWriter instance = new RedisWriter();
        instance.setEntityType(clazz.getSimpleName());
        instance.setRedisTemplate(redisTemplate);
        return instance;
    }

    public static synchronized <T> RedisWriter getInstanceBySimpleName(String clazzSimpleName, RedisTemplate redisTemplate) {
        if (map.containsKey(clazzSimpleName)) {
            return map.get(clazzSimpleName);
        }
        RedisWriter instance = new RedisWriter();
        instance.setEntityType(clazzSimpleName);
        instance.setRedisTemplate(redisTemplate);
        map.put(instance.getEntityType(), instance);
        return map.get(clazzSimpleName);
    }

    public static <T> RedisWriter getInstance(Class<T> clazz, RedisTemplate redisTemplate) {
        return RedisWriterService.getInstanceBySimpleName(clazz.getSimpleName(), redisTemplate);
    }
}

