/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.entity.BaseEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisWriter {
    private RedisTemplate redisTemplate;
    private String entityType;

    private String getHead() {
        return "fox.edge.entity." + this.getEntityType() + ".";
    }

    public synchronized void writeEntityMap(Map<String, BaseEntity> dataMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        Long time = System.currentTimeMillis();
        HashMap<String, Long> agileMap = new HashMap<String, Long>();
        for (String key : dataMap.keySet()) {
            agileMap.put(key, time);
        }
        this.redisTemplate.opsForHash().putAll((Object)(this.getHead() + "agile"), agileMap);
        this.redisTemplate.opsForHash().putAll((Object)(this.getHead() + "data"), dataMap);
        this.redisTemplate.opsForValue().set((Object)(this.getHead() + "sync"), (Object)time);
    }

    public synchronized void deleteEntity(Set<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Long time = System.currentTimeMillis();
        for (String key : keys) {
            this.redisTemplate.opsForHash().delete((Object)(this.getHead() + "agile"), new Object[]{key});
            this.redisTemplate.opsForHash().delete((Object)(this.getHead() + "data"), new Object[]{key});
            this.redisTemplate.opsForValue().set((Object)(this.getHead() + "sync"), (Object)time);
        }
    }

    public void deleteEntity(String key) {
        HashSet<String> keys = new HashSet<String>();
        keys.add(key);
        this.deleteEntity(keys);
    }

    public void writeEntityList(List<BaseEntity> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        HashMap<String, BaseEntity> dataMap = new HashMap<String, BaseEntity>();
        for (BaseEntity entity : dataList) {
            dataMap.put(entity.makeServiceKey(), entity);
        }
        this.writeEntityMap(dataMap);
    }

    public void writeEntity(BaseEntity entity) {
        if (entity == null) {
            return;
        }
        HashMap<String, BaseEntity> dataMap = new HashMap<String, BaseEntity>();
        dataMap.put(entity.makeServiceKey(), entity);
        this.writeEntityMap(dataMap);
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }
}

