/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.service.redis.BaseEntityClassFactory;
import cn.foxtech.common.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisReader {
    private RedisTemplate redisTemplate;
    private String entityType;

    private String getHead() {
        return "fox.edge.entity." + this.getEntityType() + ".";
    }

    public synchronized Map<String, Object> readAgileMap() {
        return this.redisTemplate.opsForHash().entries((Object)(this.getHead() + "agile"));
    }

    public synchronized Object readSync() {
        return this.redisTemplate.opsForValue().get((Object)(this.getHead() + "sync"));
    }

    public synchronized Map<String, BaseEntity> readEntityMap() throws JsonParseException {
        Map dataJsn = this.redisTemplate.opsForHash().entries((Object)(this.getHead() + "data"));
        Map<String, BaseEntity> dataRds = this.makeJson2EntityMap(dataJsn);
        return dataRds;
    }

    public synchronized Map<String, Object> readHashMap() {
        Map dataJsn = this.redisTemplate.opsForHash().entries((Object)(this.getHead() + "data"));
        return dataJsn;
    }

    public List<BaseEntity> readEntityList() throws JsonParseException {
        ArrayList<BaseEntity> result = new ArrayList<BaseEntity>();
        Map<String, BaseEntity> dataRds = this.readEntityMap();
        result.addAll(dataRds.values());
        return result;
    }

    public List<Map<String, Object>> readHashMapList() throws JsonParseException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map<String, Object> dataRds = this.readHashMap();
        for (Object data : dataRds.values()) {
            if (data == null || !(data instanceof Map)) continue;
            result.add((Map)data);
        }
        return result;
    }

    public synchronized Map<String, BaseEntity> readEntityMap(Collection hKeys) throws JsonParseException {
        List jsonList = this.redisTemplate.opsForHash().multiGet((Object)(this.getHead() + "data"), hKeys);
        return this.makeJson2EntityList(jsonList);
    }

    public synchronized BaseEntity readEntity(String serviceKey) throws IOException {
        Class entityClass = BaseEntityClassFactory.getInstance(this.getEntityType());
        Map dataJsn = (Map)this.redisTemplate.opsForHash().get((Object)(this.getHead() + "data"), (Object)serviceKey);
        return this.makeJson2Entity(entityClass, dataJsn);
    }

    public synchronized Map<String, Object> readHashMap(String serviceKey) {
        return (Map)this.redisTemplate.opsForHash().get((Object)(this.getHead() + "data"), (Object)serviceKey);
    }

    private BaseEntity makeJson2Entity(Class entityClass, Map<String, Object> jsonObject) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsn = objectMapper.writeValueAsString(jsonObject);
        BaseEntity entity = (BaseEntity)objectMapper.readValue(jsn, entityClass);
        return entity;
    }

    private Map<String, BaseEntity> makeJson2EntityList(List<Object> jsonList) throws JsonParseException {
        Class entityClass = BaseEntityClassFactory.getInstance(this.getEntityType());
        ConcurrentHashMap<String, BaseEntity> result = new ConcurrentHashMap<String, BaseEntity>();
        for (Object json : jsonList) {
            Map jsonObject = (Map)json;
            if (jsonObject == null) continue;
            BaseEntity entity = (BaseEntity)JsonUtils.buildObject((Map)jsonObject, (Class)entityClass);
            result.put(entity.makeServiceKey(), entity);
        }
        return result;
    }

    private Map<String, BaseEntity> makeJson2EntityMap(Map<String, Object> jsonMap) throws JsonParseException {
        Class entityClass = BaseEntityClassFactory.getInstance(this.getEntityType());
        ConcurrentHashMap<String, BaseEntity> result = new ConcurrentHashMap<String, BaseEntity>();
        for (Map.Entry<String, Object> entry : jsonMap.entrySet()) {
            Map jsonObject = (Map)entry.getValue();
            if (jsonObject == null) continue;
            BaseEntity entity = (BaseEntity)JsonUtils.buildObject((Map)jsonObject, (Class)entityClass);
            result.put(entry.getKey(), entity);
        }
        return result;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }
}

