/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.service.redis.BaseProducerRedisService;
import cn.foxtech.utils.common.utils.redis.service.RedisService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProducerRedisService
extends BaseProducerRedisService {
    private static final Map<String, ProducerRedisService> map = new ConcurrentHashMap<String, ProducerRedisService>();
    private String entityType;
    private RedisService redisService;

    public static synchronized ProducerRedisService getInstanceBySimpleName(String clazzSimpleName, RedisService redisService) {
        if (map.containsKey(clazzSimpleName)) {
            return map.get(clazzSimpleName);
        }
        ProducerRedisService instance = new ProducerRedisService();
        instance.entityType = clazzSimpleName;
        instance.redisService = redisService;
        map.put(instance.entityType, instance);
        return map.get(clazzSimpleName);
    }

    public static synchronized void removeInstanceBySimpleName(ProducerRedisService producerRedisService) {
        map.remove(producerRedisService.entityType);
    }

    public static <T> ProducerRedisService getInstance(Class<T> clazz, RedisService redisService) {
        return ProducerRedisService.getInstanceBySimpleName(clazz.getSimpleName(), redisService);
    }

    public static <T> ProducerRedisService getInstance(String simpleName, RedisService redisService) {
        return ProducerRedisService.getInstanceBySimpleName(simpleName, redisService);
    }

    @Override
    public RedisService getRedisService() {
        return this.redisService;
    }

    @Override
    public String getEntityType() {
        return this.entityType;
    }
}

