/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.service.redis.BaseHashMapRedisService;
import cn.foxtech.common.entity.service.redis.HashMapRedisNotify;
import cn.foxtech.utils.common.utils.redis.service.RedisService;
import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HashMapRedisService
extends BaseHashMapRedisService {
    private static final Map<String, HashMapRedisService> map = new ConcurrentHashMap<String, HashMapRedisService>();
    private String entityType;
    private RedisService redisService;

    public static synchronized <T> HashMapRedisService newInstance(Class<T> clazz, RedisService redisService) {
        HashMapRedisService instance = new HashMapRedisService();
        instance.entityType = clazz.getSimpleName();
        instance.redisService = redisService;
        return instance;
    }

    public static synchronized <T> HashMapRedisService getInstanceBySimpleName(String clazzSimpleName, RedisService redisService) {
        if (map.containsKey(clazzSimpleName)) {
            return map.get(clazzSimpleName);
        }
        HashMapRedisService instance = new HashMapRedisService();
        instance.entityType = clazzSimpleName;
        instance.redisService = redisService;
        map.put(instance.entityType, instance);
        return map.get(clazzSimpleName);
    }

    public static <T> HashMapRedisService getInstance(Class<T> clazz, RedisService redisService) {
        return HashMapRedisService.getInstanceBySimpleName(clazz.getSimpleName(), redisService);
    }

    @Override
    public boolean isNeedLoad() {
        return super.isNeedLoad();
    }

    @Override
    public void loadAllEntities() throws JsonParseException {
        super.loadAllEntities();
    }

    @Override
    public void bind(HashMapRedisNotify notify) {
        super.bind(notify);
    }

    @Override
    public void loadAgileEntities() throws IOException {
        super.loadAgileEntities();
    }

    @Override
    public Map<String, Map<String, Object>> getEntitys() {
        return super.getEntitys();
    }

    @Override
    public Map<String, Object> getEntity(String entityKey) {
        return super.getEntity(entityKey);
    }

    @Override
    public RedisService getRedisService() {
        return this.redisService;
    }

    @Override
    public String getEntityType() {
        return this.entityType;
    }
}

