/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.entity.service.redis.HashMapRedisNotify;
import cn.foxtech.common.entity.service.redis.IBaseFinder;
import cn.foxtech.common.utils.DifferUtils;
import cn.foxtech.utils.common.utils.redis.service.RedisService;
import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseHashMapRedisService {
    private Map<String, Map<String, Object>> dataMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private Map<String, Long> agileMap = new ConcurrentHashMap<String, Long>();
    private Long updateTime = 0L;
    private boolean needSave = false;
    private boolean inited = false;
    private HashMapRedisNotify notify = null;

    public abstract RedisService getRedisService();

    public abstract String getEntityType();

    public boolean isInited() {
        return this.inited;
    }

    public void setInited() {
        this.inited = true;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    protected void bind(HashMapRedisNotify notify) {
        this.notify = notify;
    }

    protected String getHead() {
        return "fox.edge.entity." + this.getEntityType() + ".";
    }

    protected void loadAllEntities() throws JsonParseException {
        this.updateTime = (Long)this.getRedisService().getCacheObject(this.getHead() + "sync");
        if (this.updateTime == null) {
            this.updateTime = 0L;
        }
        this.agileMap = this.getRedisService().getCacheMap(this.getHead() + "agile");
        Map jsonMap = this.getRedisService().getCacheMap(this.getHead() + "data");
        this.dataMap = this.makeEntityMap(jsonMap);
    }

    private Map<String, Map<String, Object>> makeEntityMap(Map<String, Object> jsonMap) throws JsonParseException {
        ConcurrentHashMap<String, Map<String, Object>> result = new ConcurrentHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Object> entry : jsonMap.entrySet()) {
            String key = entry.getKey();
            Map value = (Map)entry.getValue();
            this.makeLong(value);
            result.put(key, value);
        }
        return result;
    }

    private void makeLong(Map<String, Object> jsonMap) {
        jsonMap.put("id", this.makeLong(jsonMap.get("id")));
        jsonMap.put("createTime", this.makeLong(jsonMap.get("createTime")));
        jsonMap.put("updateTime", this.makeLong(jsonMap.get("updateTime")));
    }

    private Long makeLong(Object object) {
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        return null;
    }

    protected void loadAgileEntities() throws IOException {
        this.updateTime = (Long)this.getRedisService().getCacheObject(this.getHead() + "sync");
        Map newUpdateTimes = this.getRedisService().getCacheMap(this.getHead() + "agile");
        HashSet addList = new HashSet();
        HashSet<String> delList = new HashSet<String>();
        HashSet eqlList = new HashSet();
        DifferUtils.differByValue(this.agileMap.keySet(), newUpdateTimes.keySet(), addList, delList, eqlList);
        if (!addList.isEmpty() || !delList.isEmpty()) {
            this.loadAllEntities();
        } else {
            Map<String, Long> diff = this.compare(this.agileMap, newUpdateTimes);
            if (diff.size() * 10 > this.agileMap.size() || diff.size() > 64) {
                this.loadAllEntities();
            } else {
                for (Map.Entry<String, Long> entry : diff.entrySet()) {
                    Map jsonObject = (Map)this.getRedisService().getCacheMapValue(this.getHead() + "data", entry.getKey());
                    this.makeLong(jsonObject);
                    Long agile = (Long)newUpdateTimes.get(entry.getKey());
                    this.dataMap.put(entry.getKey(), jsonObject);
                    this.agileMap.put(entry.getKey(), agile);
                }
            }
            if (this.notify == null) {
                return;
            }
            HashMap<String, Map<String, Object>> addMap = new HashMap<String, Map<String, Object>>();
            HashMap<String, Map<String, Object>> mdyMap = new HashMap<String, Map<String, Object>>();
            for (String key : addList) {
                addMap.put(key, this.dataMap.get(key));
            }
            for (String key : diff.keySet()) {
                mdyMap.put(key, this.dataMap.get(key));
            }
            if (addMap.isEmpty() && delList.isEmpty() && mdyMap.isEmpty()) {
                return;
            }
            this.notify.notify(this.getEntityType(), this.updateTime, addMap, delList, mdyMap);
        }
    }

    private <T> void saveAllEntities(String mainKey, Map<String, T> cacheMap) {
        this.getRedisService().setCacheMap(mainKey, cacheMap);
        Map redisRedis = this.getRedisService().getCacheMap(mainKey);
        HashSet add = new HashSet();
        HashSet del = new HashSet();
        HashSet eql = new HashSet();
        DifferUtils.differByValue(redisRedis.keySet(), cacheMap.keySet(), add, del, eql);
        for (String hashKey : del) {
            this.getRedisService().deleteCacheMap(mainKey, hashKey);
        }
    }

    protected void saveAllEntities() {
        this.saveAllEntities(this.getHead() + "agile", this.agileMap);
        this.saveAllEntities(this.getHead() + "data", this.dataMap);
        this.updateTime = System.currentTimeMillis();
        this.getRedisService().setCacheObject(this.getHead() + "sync", (Object)this.updateTime);
        this.needSave = false;
    }

    private Map<String, Long> compare(Map<String, Long> newDatas, Map<String, Long> oldDatas) {
        ConcurrentHashMap<String, Long> diff = new ConcurrentHashMap<String, Long>();
        if (newDatas.size() != oldDatas.size()) {
            return diff;
        }
        for (Map.Entry<String, Long> entry : newDatas.entrySet()) {
            long oldValue;
            long newValue = entry.getValue();
            if (newValue == (oldValue = oldDatas.get(entry.getKey()).longValue())) continue;
            diff.put(entry.getKey(), entry.getValue());
        }
        return diff;
    }

    protected void saveAgileEntities() {
        Long time = System.currentTimeMillis();
        Map oldUpdateTimes = this.getRedisService().getCacheMap(this.getHead() + "agile");
        if (DifferUtils.differByValue(oldUpdateTimes.keySet(), this.agileMap.keySet())) {
            this.saveAllEntities();
        } else {
            Map<String, Long> diff = this.compare(this.agileMap, oldUpdateTimes);
            if (diff.size() * 10 > this.agileMap.size() || diff.size() > 64) {
                this.saveAllEntities();
            } else {
                for (Map.Entry<String, Long> entry : diff.entrySet()) {
                    this.getRedisService().setCacheMapValue(this.getHead() + "data", entry.getKey(), this.dataMap.get(entry.getKey()));
                    this.getRedisService().setCacheMapValue(this.getHead() + "agile", entry.getKey(), (Object)time);
                    this.agileMap.put(entry.getKey(), time);
                }
                String entitiesSyncKey = this.getHead() + "sync";
                this.updateTime = time;
                this.getRedisService().setCacheObject(entitiesSyncKey, (Object)this.updateTime);
                this.needSave = false;
            }
        }
    }

    protected void cleanAgileEntities() {
        this.getRedisService().deleteObject(this.getHead() + "agile");
        this.getRedisService().deleteObject(this.getHead() + "data");
        this.getRedisService().deleteObject(this.getHead() + "sync");
    }

    protected boolean isNeedLoad() {
        Long updateTime = (Long)this.getRedisService().getCacheObject(this.getHead() + "sync");
        if (updateTime == null) {
            return false;
        }
        return !this.updateTime.equals(updateTime);
    }

    protected boolean isNeedSave() {
        return this.needSave;
    }

    protected Map<String, Map<String, Object>> getEntitys() {
        return new ConcurrentHashMap<String, Map<String, Object>>(this.dataMap);
    }

    protected Map<String, Object> getEntity(String entityKey) {
        if (!this.dataMap.containsKey(entityKey)) {
            return null;
        }
        return this.dataMap.get(entityKey);
    }

    public List<Map<String, Object>> getEntityList() {
        ArrayList<Map<String, Object>> entityList = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> operateEntry : this.dataMap.entrySet()) {
            entityList.add(operateEntry.getValue());
        }
        return entityList;
    }

    public void foreachFinder(IBaseFinder finder) {
        ArrayList<Map<String, Object>> entityList = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> operateEntry : this.dataMap.entrySet()) {
            if (!finder.compareValue(operateEntry.getValue())) continue;
            entityList.add(operateEntry.getValue());
        }
    }

    public List<Map<String, Object>> getEntityList(IBaseFinder finder) {
        ArrayList<Map<String, Object>> entityList = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> operateEntry : this.dataMap.entrySet()) {
            if (!finder.compareValue(operateEntry.getValue())) continue;
            entityList.add(operateEntry.getValue());
        }
        return entityList;
    }

    public int getEntityCount(IBaseFinder finder) {
        int count = 0;
        for (Map.Entry<String, Map<String, Object>> operateEntry : this.dataMap.entrySet()) {
            if (!finder.compareValue(operateEntry.getValue())) continue;
            ++count;
        }
        return count;
    }

    public Map<String, Object> getEntity(Long id) {
        for (Map.Entry<String, Map<String, Object>> operateEntry : this.dataMap.entrySet()) {
            Map<String, Object> value = operateEntry.getValue();
            Object vid = value.get("id");
            if (!id.equals(vid)) continue;
            return operateEntry.getValue();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }
}

