/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.redis;

import cn.foxtech.common.utils.DifferUtils;
import cn.foxtech.utils.common.utils.redis.service.RedisService;
import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseAgileMapRedisService {
    private final Map<String, Long> agileMap = new ConcurrentHashMap<String, Long>();
    private Long updateTime = 0L;
    private boolean inited = false;

    public abstract RedisService getRedisService();

    public abstract String getEntityType();

    public boolean isInited() {
        return this.inited;
    }

    public void setInited() {
        this.inited = true;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    protected String getHead() {
        return "fox.edge.entity." + this.getEntityType() + ".";
    }

    private void makeLong(Map<String, Object> jsonMap) {
        jsonMap.put("id", this.makeLong(jsonMap.get("id")));
        jsonMap.put("createTime", this.makeLong(jsonMap.get("createTime")));
        jsonMap.put("updateTime", this.makeLong(jsonMap.get("updateTime")));
    }

    private Long makeLong(Object object) {
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        return null;
    }

    public void loadAgileEntities() {
        Long sync = (Long)this.getRedisService().getCacheObject(this.getHead() + "sync");
        if (sync == null) {
            return;
        }
        this.updateTime = sync;
        HashMap newUpdateTimes = this.getRedisService().getCacheMap(this.getHead() + "agile");
        if (newUpdateTimes == null) {
            newUpdateTimes = new HashMap();
        }
        this.agileMap.clear();
        this.agileMap.putAll(newUpdateTimes);
    }

    public List<Map<String, Object>> loadAllEntities() {
        this.loadAgileEntities();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Map jsonMap = this.getRedisService().getCacheMap(this.getHead() + "data");
        for (Object data : jsonMap.values()) {
            if (data == null || !(data instanceof Map)) continue;
            resultList.add((Map)data);
        }
        return resultList;
    }

    public void loadChangeEntities(Map<String, Object> addMap, Set<String> delSet, Map<String, Object> mdyMap) throws IOException {
        Long newUpdateTime;
        Map<String, Object> data;
        Long sync = (Long)this.getRedisService().getCacheObject(this.getHead() + "sync");
        if (sync == null) {
            return;
        }
        this.updateTime = sync;
        HashMap newUpdateTimes = this.getRedisService().getCacheMap(this.getHead() + "agile");
        if (newUpdateTimes == null) {
            newUpdateTimes = new HashMap();
        }
        HashSet addList = new HashSet();
        HashSet delList = new HashSet();
        HashSet eqlList = new HashSet();
        DifferUtils.differByValue(this.agileMap.keySet(), newUpdateTimes.keySet(), addList, delList, eqlList);
        HashSet<String> mdfList = new HashSet<String>();
        for (String key : eqlList) {
            Long oldUpdateTime;
            Long newUpdateTime2 = (Long)newUpdateTimes.get(key);
            if (newUpdateTime2.equals(oldUpdateTime = this.agileMap.get(key))) continue;
            mdfList.add(key);
        }
        if (addList.isEmpty() && delList.isEmpty() && mdfList.isEmpty()) {
            return;
        }
        Map jsonMap = this.getRedisService().getCacheMap(this.getHead() + "data");
        Map<String, Map<String, Object>> dataMap = this.makeEntityMap(jsonMap);
        for (String key : addList) {
            data = dataMap.get(key);
            if (data == null) continue;
            newUpdateTime = (Long)newUpdateTimes.get(key);
            this.agileMap.put(key, newUpdateTime);
            addMap.put(key, data);
        }
        for (String key : mdfList) {
            data = dataMap.get(key);
            if (data == null) continue;
            newUpdateTime = (Long)newUpdateTimes.get(key);
            this.agileMap.put(key, newUpdateTime);
            mdyMap.put(key, data);
        }
        delSet.addAll(delList);
    }

    private Map<String, Map<String, Object>> makeEntityMap(Map<String, Object> jsonMap) throws JsonParseException {
        ConcurrentHashMap<String, Map<String, Object>> result = new ConcurrentHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Object> entry : jsonMap.entrySet()) {
            String key = entry.getKey();
            Map value = (Map)entry.getValue();
            this.makeLong(value);
            result.put(key, value);
        }
        return result;
    }

    public boolean isNeedLoad() {
        Long updateTime = (Long)this.getRedisService().getCacheObject(this.getHead() + "sync");
        if (updateTime == null) {
            return false;
        }
        return !this.updateTime.equals(updateTime);
    }

    public boolean isEmpty() {
        return this.agileMap.isEmpty();
    }
}

