/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.common.entity.service.mybatis;

import cn.foxtech.common.entity.entity.BaseEntity;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class BaseEntityService {
    protected BaseMapper mapper = null;

    public abstract void bindMapper();

    public BaseEntity selectEntity(Long id) {
        this.bindMapper();
        return (BaseEntity)this.mapper.selectById((Serializable)id);
    }

    public BaseEntity selectEntity(QueryWrapper queryWrapper) {
        this.bindMapper();
        return (BaseEntity)this.mapper.selectOne((Wrapper)queryWrapper);
    }

    public List<BaseEntity> selectEntityList(QueryWrapper queryWrapper) {
        this.bindMapper();
        return this.mapper.selectList((Wrapper)queryWrapper);
    }

    public List<BaseEntity> selectEntityList() {
        this.bindMapper();
        List entityList = this.mapper.selectList(null);
        return entityList;
    }

    public Long selectEntityListCount(Map<String, Object> param) {
        this.bindMapper();
        return this.mapper.selectCount(null);
    }

    public List selectListBatchIds(List idList) {
        this.bindMapper();
        if (idList.isEmpty()) {
            return new ArrayList();
        }
        return this.mapper.selectBatchIds((Collection)idList);
    }

    public List selectListGroupBy(String field) {
        this.bindMapper();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{field + " ,COUNT(1) AS id"}).groupBy((Object)field);
        return this.mapper.selectList((Wrapper)queryWrapper);
    }

    public List selectListGroupBy(String field1, String field2) {
        this.bindMapper();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{field1 + "," + field2 + " ,COUNT(1) AS id"}).groupBy((Object)field1, new Object[]{field2});
        return this.mapper.selectList((Wrapper)queryWrapper);
    }

    public List selectEntityListDistinct(String field) {
        this.bindMapper();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"distinct " + field}).orderByAsc((Object)field);
        return this.mapper.selectList((Wrapper)queryWrapper);
    }

    public List selectEntityListDistinct(String field1, String field2, String value1) {
        this.bindMapper();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"distinct " + field1 + "," + field2}).orderByAsc((Object)field2);
        queryWrapper.eq((Object)field1, (Object)value1);
        return this.mapper.selectList((Wrapper)queryWrapper);
    }

    public List selectEntityListDistinct(String field1, String field2, String field3, String value1) {
        this.bindMapper();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"distinct " + field1 + "," + field2 + "," + field3}).orderByAsc((Object)field2);
        queryWrapper.eq((Object)field1, (Object)value1);
        return this.mapper.selectList((Wrapper)queryWrapper);
    }

    public List selectEntityListDistinct(String field1, String field2) {
        this.bindMapper();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"distinct " + field1 + "," + field2}).orderByAsc((Object)(field1 + "," + field2));
        return this.mapper.selectList((Wrapper)queryWrapper);
    }

    public void insertEntity(BaseEntity entity) {
        this.bindMapper();
        Long time = System.currentTimeMillis();
        entity.setCreateTime(time);
        entity.setUpdateTime(time);
        this.mapper.insert((Object)entity);
    }

    public void updateEntity(BaseEntity entity) {
        this.bindMapper();
        BaseEntity exist = (BaseEntity)this.mapper.selectOne((Wrapper)((QueryWrapper)entity.makeWrapperKey()));
        if (exist == null) {
            return;
        }
        entity.setId(exist.getId());
        entity.setCreateTime(exist.getCreateTime());
        entity.setUpdateTime(System.currentTimeMillis());
        this.mapper.update((Object)entity, (Wrapper)((QueryWrapper)entity.makeWrapperKey()));
    }

    public int deleteEntity(BaseEntity entity) {
        this.bindMapper();
        return this.mapper.delete((Wrapper)((QueryWrapper)entity.makeWrapperKey()));
    }
}

