/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.socket.core.notify;

import cn.foxtech.channel.socket.core.handler.ScriptServiceKeyHandler;
import cn.foxtech.channel.socket.core.script.ScriptEngineService;
import cn.foxtech.channel.socket.core.script.ScriptServiceKey;
import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.entity.OperateEntity;
import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.entity.service.redis.BaseConsumerEntityNotify;
import org.apache.log4j.Logger;

public class OperateEntityKeyNotify
extends BaseConsumerEntityNotify {
    private static final Logger logger = Logger.getLogger(OperateEntityKeyNotify.class);
    private RedisConsoleService console;
    private ScriptEngineService scriptEngineService;
    private OperateEntity operateEntity;
    private String format;
    private ScriptServiceKeyHandler serviceKeyHandler = new ScriptServiceKeyHandler();

    public String getServiceKey() {
        return this.operateEntity.makeServiceKey();
    }

    public void notifyInsert(BaseEntity entity) {
        this.reset();
    }

    public void notifyUpdate(BaseEntity entity) {
        this.operateEntity = (OperateEntity)entity;
        this.reset();
    }

    public void reset() {
        try {
            ScriptServiceKey scriptServiceKey = this.scriptEngineService.buildServiceKeyOperate(this.operateEntity);
            scriptServiceKey.setFormat(this.format);
            this.serviceKeyHandler.setScriptServiceKey(scriptServiceKey);
        }
        catch (Exception e) {
            String message = "reset\u5f02\u5e38\uff1amanufacturer=" + this.operateEntity.getManufacturer() + "\uff0c deviceType=" + this.operateEntity.getDeviceType() + "\uff0c operateName=" + this.operateEntity.getOperateName() + e.getMessage();
            logger.error((Object)message);
            this.console.error(message);
        }
    }

    public RedisConsoleService getConsole() {
        return this.console;
    }

    public ScriptEngineService getScriptEngineService() {
        return this.scriptEngineService;
    }

    public OperateEntity getOperateEntity() {
        return this.operateEntity;
    }

    public String getFormat() {
        return this.format;
    }

    public ScriptServiceKeyHandler getServiceKeyHandler() {
        return this.serviceKeyHandler;
    }

    public void setConsole(RedisConsoleService console) {
        this.console = console;
    }

    public void setScriptEngineService(ScriptEngineService scriptEngineService) {
        this.scriptEngineService = scriptEngineService;
    }

    public void setOperateEntity(OperateEntity operateEntity) {
        this.operateEntity = operateEntity;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setServiceKeyHandler(ScriptServiceKeyHandler serviceKeyHandler) {
        this.serviceKeyHandler = serviceKeyHandler;
    }
}

