/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.service;

import cn.foxtech.common.entity.manager.InitialConfigService;
import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.utils.json.JsonUtils;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsoleLoggerPrinter {
    @Autowired
    private InitialConfigService configService;
    private String configName = "serverConfig";
    private String configValueLogger = "logger";
    private String configValueChannel = "channelName";

    public void printLogger(String channelName, String type, Object content) {
        this.printLogger("DEBUG", channelName, type, content);
    }

    public void printLogger(String level, String channelName, String type, Object content) {
        try {
            Object isLogger = this.configService.getConfigValue(this.configName, this.configValueLogger);
            if (!Boolean.TRUE.equals(isLogger)) {
                return;
            }
            Object name = this.configService.getConfigValue(this.configName, this.configValueChannel);
            if (!channelName.equals(name)) {
                return;
            }
            RedisConsoleService logger = this.configService.getLogger();
            String message = "";
            if (content == null) {
                message = "\u901a\u9053\u540d\u79f0\uff1a" + channelName + "\n" + type + "\uff1a" + null;
            }
            if (content instanceof String) {
                message = "\u901a\u9053\u540d\u79f0\uff1a" + channelName + "\n" + type + "\uff1a" + content;
            }
            if (content instanceof Map || content instanceof List) {
                message = "\u901a\u9053\u540d\u79f0\uff1a" + channelName + "\n" + type + "\uff1a" + JsonUtils.buildJsonWithoutException((Object)content);
            }
            if (message.isEmpty()) {
                return;
            }
            if ("DEBUG".equals(level)) {
                logger.debug(message);
                return;
            }
            if ("INFO".equals(level)) {
                logger.info(message);
                return;
            }
            if ("WARN".equals(level)) {
                logger.warn(message);
            }
            if ("ERROR".equals(level)) {
                logger.error(message);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public InitialConfigService getConfigService() {
        return this.configService;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigValueLogger() {
        return this.configValueLogger;
    }

    public String getConfigValueChannel() {
        return this.configValueChannel;
    }

    public void setConfigService(InitialConfigService configService) {
        this.configService = configService;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void setConfigValueLogger(String configValueLogger) {
        this.configValueLogger = configValueLogger;
    }

    public void setConfigValueChannel(String configValueChannel) {
        this.configValueChannel = configValueChannel;
    }
}

