/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.service;

import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.channel.common.service.EntityManageService;
import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.entity.ChannelEntity;
import cn.foxtech.common.entity.entity.ChannelStatusEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChannelStatusUpdater {
    @Autowired
    private EntityManageService entityManageService;
    @Autowired
    private ChannelProperties channelProperties;

    public void updateOpenStatus(String channelName, boolean isOpen) {
        ChannelEntity finder = new ChannelEntity();
        finder.setChannelType(this.channelProperties.getChannelType());
        finder.setChannelName(channelName);
        ChannelEntity channelEntity = (ChannelEntity)this.entityManageService.getEntity(finder.makeServiceKey(), ChannelEntity.class);
        if (channelEntity == null) {
            return;
        }
        ChannelStatusEntity entity = new ChannelStatusEntity();
        entity.bind(channelEntity);
        ChannelStatusEntity exist = (ChannelStatusEntity)this.entityManageService.getEntity(entity.makeServiceKey(), ChannelStatusEntity.class);
        if (exist != null) {
            exist.setOpen(isOpen);
            this.entityManageService.updateRDEntity((BaseEntity)exist);
            return;
        }
        entity.setId(channelEntity.getId());
        entity.setUpdateTime(channelEntity.getUpdateTime());
        entity.setOpen(isOpen);
        this.entityManageService.insertRDEntity((BaseEntity)entity);
    }

    public void updateParamStatus(String channelName, String key, Object value) {
        ChannelStatusEntity channelStatusEntity = new ChannelStatusEntity();
        channelStatusEntity.setChannelType(this.channelProperties.getChannelType());
        channelStatusEntity.setChannelName(channelName);
        ChannelStatusEntity exist = (ChannelStatusEntity)this.entityManageService.getEntity(channelStatusEntity.makeServiceKey(), ChannelStatusEntity.class);
        if (exist == null) {
            return;
        }
        exist.getChannelParam().put(key, value);
        this.entityManageService.updateRDEntity((BaseEntity)exist);
    }
}

