/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.scheduler;

import cn.foxtech.channel.common.api.ChannelClientAPI;
import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.channel.common.service.ChannelStatusUpdater;
import cn.foxtech.channel.common.service.EntityManageService;
import cn.foxtech.common.entity.entity.BaseEntity;
import cn.foxtech.common.entity.entity.ChannelEntity;
import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.utils.DifferUtils;
import cn.foxtech.common.utils.scheduler.singletask.PeriodTaskService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityManageScheduler
extends PeriodTaskService {
    private static final Logger logger = Logger.getLogger(EntityManageScheduler.class);
    @Autowired
    private EntityManageService entityManageService;
    @Autowired
    private ChannelClientAPI channelService;
    @Autowired
    private ChannelProperties channelProperties;
    @Autowired
    private ChannelStatusUpdater channelStatusUpdater;
    private Map<String, ChannelEntity> channelEntityMap;
    @Autowired
    private RedisConsoleService console;

    public void execute(long threadId) throws Exception {
        Thread.sleep(1000L);
        this.entityManageService.syncEntity();
        this.syncChannelConfig();
    }

    private void syncChannelConfig() {
        String message;
        ChannelEntity channelEntity;
        String channelType = this.channelProperties.getChannelType();
        Long updateTime = this.entityManageService.removeReloadedFlag(ChannelEntity.class.getSimpleName());
        if (updateTime == null && this.channelEntityMap != null) {
            return;
        }
        List entityList = this.entityManageService.getChannelEntity(channelType);
        HashMap<String, ChannelEntity> map = new HashMap<String, ChannelEntity>();
        for (BaseEntity entity : entityList) {
            ChannelEntity channelEntity2 = (ChannelEntity)entity;
            map.put(channelEntity2.getChannelName(), channelEntity2);
        }
        if (this.channelEntityMap == null) {
            this.channelEntityMap = new HashMap<String, ChannelEntity>();
        }
        HashSet addList = new HashSet();
        HashSet delList = new HashSet();
        HashSet eqlList = new HashSet();
        DifferUtils.differByValue(this.channelEntityMap.keySet(), map.keySet(), addList, delList, eqlList);
        for (String key : addList) {
            try {
                channelEntity = (ChannelEntity)map.get(key);
                this.channelService.openChannel(channelEntity.getChannelName(), channelEntity.getChannelParam());
                this.channelEntityMap.put(key, channelEntity);
                this.channelStatusUpdater.updateOpenStatus(key, true);
                message = "\u901a\u9053\u6253\u5f00\u6210\u529f:" + key;
                this.console.info(message);
                logger.info((Object)message);
            }
            catch (Exception e) {
                message = "\u901a\u9053\u6253\u5f00\u5931\u8d25:" + key + ":" + e.getMessage();
                this.console.error(message);
                logger.error((Object)message);
                this.channelStatusUpdater.updateOpenStatus(key, false);
            }
        }
        for (String key : delList) {
            try {
                channelEntity = this.channelEntityMap.get(key);
                this.channelService.closeChannel(channelEntity.getChannelName(), channelEntity.getChannelParam());
                this.channelEntityMap.remove(key);
                this.channelStatusUpdater.updateOpenStatus(key, false);
                message = "\u901a\u9053\u5173\u95ed\u6210\u529f:" + key;
                this.console.info(message);
                logger.info((Object)message);
            }
            catch (Exception e) {
                message = "\u901a\u9053\u5173\u95ed\u5931\u8d25:" + key + ":" + e.getMessage();
                this.console.error(message);
                logger.error((Object)message);
            }
        }
        for (String key : eqlList) {
            try {
                ChannelEntity oldEntity = this.channelEntityMap.get(key);
                ChannelEntity newEntity = (ChannelEntity)map.get(key);
                String newValue = newEntity.makeServiceValue();
                String oldValue = oldEntity.makeServiceValue();
                if (newValue.equals(oldValue)) continue;
                this.channelService.closeChannel(oldEntity.getChannelName(), oldEntity.getChannelParam());
                this.channelEntityMap.remove(key);
                this.channelStatusUpdater.updateOpenStatus(key, false);
                this.channelService.openChannel(newEntity.getChannelName(), newEntity.getChannelParam());
                this.channelEntityMap.put(key, newEntity);
                this.channelStatusUpdater.updateOpenStatus(key, true);
                String message2 = "\u901a\u9053\u91cd\u7f6e\u6210\u529f:" + key;
                this.console.info(message2);
                logger.info((Object)message2);
            }
            catch (Exception e) {
                message = "\u901a\u9053\u91cd\u7f6e\u5931\u8d25:" + key + ":" + e.getMessage();
                this.console.error(message);
                logger.error((Object)message);
            }
        }
    }
}

