/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.service;

import cn.foxtech.channel.common.api.ChannelClientAPI;
import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.channel.domain.ChannelBaseVO;
import cn.foxtech.channel.domain.ChannelRequestVO;
import cn.foxtech.channel.domain.ChannelRespondVO;
import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.common.utils.method.MethodUtils;
import cn.foxtech.common.utils.redis.topic.service.RedisTopicSubscriber;
import cn.foxtech.common.utils.syncobject.SyncQueueObjectMap;
import cn.foxtech.core.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisTopicSuberService
extends RedisTopicSubscriber {
    @Autowired
    private RedisConsoleService logger;
    @Autowired
    private ChannelClientAPI channelService;
    @Autowired
    private ChannelProperties constants;

    public String topic1st() {
        return "topic_channel_request_" + this.constants.getChannelType();
    }

    public void receiveTopic1st(String message) {
        try {
            ChannelRequestVO requestVO = (ChannelRequestVO)JsonUtils.buildObject((String)message, ChannelRequestVO.class);
            if (ChannelRequestVO.MODE_EXCHANGE.equals(requestVO.getMode())) {
                ChannelRespondVO respondVO = this.execute(requestVO);
                if (MethodUtils.hasEmpty((Object[])new Object[]{respondVO.getRoute()})) {
                    respondVO.setRoute("topic_channel_respond_device");
                }
                respondVO.setUuid(requestVO.getUuid());
                respondVO.setType(this.constants.getChannelType());
                String json = JsonUtils.buildJson((Object)respondVO);
                SyncQueueObjectMap.inst().push(respondVO.getRoute(), (Object)json, 1000);
            } else if (ChannelRequestVO.MODE_PUBLISH.equals(requestVO.getMode())) {
                ChannelRespondVO respondVO = this.publish(requestVO);
                if (MethodUtils.hasEmpty((Object[])new Object[]{respondVO.getRoute()})) {
                    respondVO.setRoute("topic_channel_respond_device");
                }
                respondVO.setUuid(requestVO.getUuid());
                respondVO.setType(this.constants.getChannelType());
                String json = JsonUtils.buildJson((Object)respondVO);
                SyncQueueObjectMap.inst().push(respondVO.getRoute(), (Object)json, 1000);
            } else if (ChannelRequestVO.MODE_MANAGE.equals(requestVO.getMode())) {
                ChannelRespondVO respondVO = this.manage(requestVO);
                respondVO.setUuid(requestVO.getUuid());
                respondVO.setType(this.constants.getChannelType());
                String json = JsonUtils.buildJson((Object)respondVO);
                SyncQueueObjectMap.inst().push("topic_channel_respond_manager", (Object)json, 10);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    private ChannelRespondVO execute(ChannelRequestVO requestVO) {
        try {
            if (requestVO.getTimeout() > 60000) {
                throw new ServiceException("\u4e3a\u4e86\u907f\u514d\u8bbe\u5907\u6ca1\u54cd\u5e94\u65f6\u9020\u6210\u5835\u585e\uff0c\u4e0d\u5141\u8bb8\u6700\u5927\u8d85\u65f6\u5927\u4e8e1\u5206\u949f!");
            }
            return this.channelService.execute(requestVO);
        }
        catch (Exception e) {
            return ChannelRespondVO.error((ChannelBaseVO)requestVO, (String)("exchange \u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private ChannelRespondVO publish(ChannelRequestVO requestVO) {
        try {
            this.channelService.publish(requestVO);
            ChannelRespondVO respondVO = new ChannelRespondVO();
            respondVO.bindBaseVO((ChannelBaseVO)requestVO);
            respondVO.setRecv(null);
            return respondVO;
        }
        catch (Exception e) {
            return ChannelRespondVO.error((ChannelBaseVO)requestVO, (String)("publish \u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private ChannelRespondVO manage(ChannelRequestVO requestVO) {
        try {
            return this.channelService.manageChannel(requestVO);
        }
        catch (Exception e) {
            return ChannelRespondVO.error((ChannelBaseVO)requestVO, (String)("publish \u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

