/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.service;

import cn.foxtech.channel.common.api.ChannelClientAPI;
import cn.foxtech.channel.domain.ChannelRespondVO;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.common.utils.redis.topic.service.RedisTopicPublisher;
import cn.foxtech.common.utils.scheduler.singletask.PeriodTaskService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisTopicReportToDeviceService
extends PeriodTaskService {
    private final String deviceTopic = "topic_channel_respond_device";
    @Autowired
    private RedisTopicPublisher publisher;
    @Autowired
    private ChannelClientAPI channelService;

    public void execute(long threadId) throws Exception {
        List<ChannelRespondVO> respondVOList = this.channelService.reportTo(60000L);
        for (ChannelRespondVO respondVO : respondVOList) {
            respondVO.setMode(ChannelRespondVO.MODE_RECEIVE);
            String json = JsonUtils.buildJsonWithoutException((Object)respondVO);
            this.publisher.sendMessage(this.deviceTopic, (Object)json);
        }
    }
}

