/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.redislist;

import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.common.domain.vo.RestFulRequestVO;
import cn.foxtech.common.entity.entity.ChannelEntity;
import cn.foxtech.common.entity.entity.DeviceEntity;
import cn.foxtech.common.utils.redis.logger.RedisLoggerService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisListRestfulMessage
extends RedisLoggerService {
    @Autowired
    private ChannelProperties channelProperties;

    public RedisListRestfulMessage() {
        this.setKey("fox.edge.list.manager.restful.message");
    }

    public void createChannel(String channelName, Map<String, Object> channelParam) {
        ChannelEntity entity = new ChannelEntity();
        entity.setChannelType(this.channelProperties.getChannelType());
        entity.setChannelName(channelName);
        if (channelParam != null) {
            entity.setChannelParam(channelParam);
        }
        RestFulRequestVO requestVO = new RestFulRequestVO();
        requestVO.setUri("/kernel/manager/channel/entity");
        requestVO.setMethod("post");
        requestVO.setData((Object)entity);
        this.push(requestVO);
    }

    public void createDevice(String manufacturer, String deviceType, String deviceName, String channelName, Map<String, Object> deviceParam) {
        DeviceEntity entity = new DeviceEntity();
        entity.setManufacturer(manufacturer);
        entity.setDeviceType(deviceType);
        entity.setDeviceName(deviceName);
        entity.setChannelType(this.channelProperties.getChannelType());
        entity.setChannelName(channelName);
        if (deviceParam != null) {
            entity.setDeviceParam(deviceParam);
        }
        RestFulRequestVO requestVO = new RestFulRequestVO();
        requestVO.setUri("/kernel/manager/device/entity");
        requestVO.setMethod("post");
        requestVO.setData((Object)entity);
        this.push(requestVO);
    }
}

