/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.service;

import cn.foxtech.channel.common.api.ChannelClientAPI;
import cn.foxtech.channel.domain.ChannelRespondVO;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.common.utils.redis.topic.service.RedisTopicPublisher;
import cn.foxtech.common.utils.scheduler.singletask.PeriodTaskService;
import cn.foxtech.common.utils.syncobject.SyncQueueObjectMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisTopicRespondDeviceService
extends PeriodTaskService {
    private final String deviceTopic = "topic_channel_respond_device";
    @Autowired
    private RedisTopicPublisher publisher;
    @Autowired
    private ChannelClientAPI channelService;

    public void execute(long threadId) throws Exception {
        this.getReceive();
        List privateList = SyncQueueObjectMap.inst().popup("topic_channel_respond_device");
        for (Object object : privateList) {
            this.publisher.sendMessage("topic_channel_respond_device", object);
        }
    }

    private void getReceive() {
        List<ChannelRespondVO> respondVOList = this.channelService.receive();
        for (ChannelRespondVO respondVO : respondVOList) {
            respondVO.setMode(ChannelRespondVO.MODE_RECEIVE);
            String json = JsonUtils.buildJsonWithoutException((Object)respondVO);
            SyncQueueObjectMap.inst().push("topic_channel_respond_device", (Object)json, 1000);
        }
    }
}

