/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.linker;

import cn.foxtech.channel.common.linker.LinkerEntity;
import cn.foxtech.channel.common.linker.LinkerHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinkerManager {
    private static final Map<String, LinkerEntity> channelMap = new HashMap<String, LinkerEntity>();
    private static LinkerHandler handler = new LinkerHandler();

    public static synchronized void bindHandler(LinkerHandler newHandler) {
        handler = newHandler;
    }

    public static synchronized void registerChannel(String channelName) {
        if (channelMap.containsKey(channelName)) {
            return;
        }
        channelMap.put(channelName, new LinkerEntity());
        channelMap.get(channelName).setChannelName(channelName);
        channelMap.get(channelName).setLinked(false);
    }

    public static synchronized void unregisterChannel(String channelName) {
        if (!channelMap.containsKey(channelName)) {
            return;
        }
        channelMap.get(channelName).setLinked(false);
        handler.linkDisconnected(channelMap.get(channelName));
        channelMap.remove(channelName);
    }

    public static synchronized void updateEntity4LinkStatus(String channelName, boolean isLinked) {
        if (!channelMap.containsKey(channelName)) {
            return;
        }
        channelMap.get(channelName).setLinked(isLinked);
        if (isLinked) {
            handler.linkConnected(channelMap.get(channelName));
        } else {
            handler.linkDisconnected(channelMap.get(channelName));
        }
    }

    public static synchronized void updateEntity4ActiveLinker(String channelName, boolean activeSuccess) {
        if (!channelMap.containsKey(channelName)) {
            return;
        }
        if (activeSuccess) {
            channelMap.get(channelName).setLastActive(System.currentTimeMillis());
            channelMap.get(channelName).setFailActive(0L);
        } else {
            long count = channelMap.get(channelName).getFailActive();
            channelMap.get(channelName).setFailActive(count + 1L);
        }
    }

    public static synchronized List<LinkerEntity> queryEntityListByLinkStatus(boolean linkStatus) {
        ArrayList<LinkerEntity> resultList = new ArrayList<LinkerEntity>();
        for (Map.Entry<String, LinkerEntity> entry : channelMap.entrySet()) {
            LinkerEntity entity = entry.getValue();
            if (entity.isLinked() != linkStatus) continue;
            resultList.add(entity);
        }
        return resultList;
    }

    public static synchronized LinkerEntity queryEntity(String channelName) {
        return channelMap.get(channelName);
    }
}

