/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.linker;

import cn.foxtech.channel.common.api.ChannelServerAPI;
import cn.foxtech.channel.common.linker.LinkerEntity;
import cn.foxtech.channel.common.linker.LinkerManager;
import cn.foxtech.channel.common.linker.LinkerMethodEntity;
import cn.foxtech.channel.common.linker.LinkerMethodTemplate;
import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.channel.common.service.EntityManageService;
import cn.foxtech.channel.domain.ChannelRequestVO;
import cn.foxtech.channel.domain.ChannelRespondVO;
import cn.foxtech.common.entity.entity.ChannelEntity;
import cn.foxtech.common.utils.scheduler.multitask.PeriodTask;
import cn.foxtech.common.utils.scheduler.multitask.PeriodTaskType;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkerCreateLinkerPeriodTask
extends PeriodTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkerCreateLinkerPeriodTask.class);
    @Autowired
    private ChannelServerAPI channelService;
    @Autowired
    private EntityManageService entityManageService;
    @Autowired
    private ChannelProperties channelProperties;
    @Autowired
    private LinkerMethodTemplate methodTemplate;

    public int getTaskType() {
        return PeriodTaskType.task_type_share;
    }

    public int getSchedulePeriod() {
        return 1;
    }

    public void execute() {
        List<LinkerEntity> entities = LinkerManager.queryEntityListByLinkStatus(false);
        if (entities.isEmpty()) {
            return;
        }
        for (LinkerEntity entity : entities) {
            this.createLink(entity.getChannelName());
        }
    }

    private void createLink(String channelName) {
        try {
            ChannelEntity channelEntity = this.entityManageService.getChannelEntity(channelName, this.channelProperties.getChannelType());
            if (channelEntity == null) {
                return;
            }
            Object linkEncoder = channelEntity.getChannelParam().get("link-encoder");
            if (linkEncoder == null) {
                return;
            }
            LinkerMethodEntity methodEntity = this.methodTemplate.getMap().get(linkEncoder);
            if (methodEntity == null) {
                return;
            }
            ChannelRequestVO requestVO = new ChannelRequestVO();
            requestVO.setName(channelName);
            requestVO.setUuid(UUID.randomUUID().toString());
            requestVO.setTimeout(Integer.valueOf(2000));
            requestVO.setSend(methodEntity.getEncodeCreateLinkerRequest().invoke((Object)this, channelEntity.getChannelParam()));
            LOGGER.info("\u5efa\u7acb\u94fe\u8def:" + channelName);
            ChannelRespondVO respondVO = this.channelService.execute(requestVO);
            if (respondVO.getCode() != 200) {
                LOGGER.info("\u5efa\u7acb\u94fe\u8def\u5931\u8d25:" + channelName + ",\u539f\u56e0:" + respondVO.getMsg());
                return;
            }
            if (!((Boolean)methodEntity.getDecodeCreateLinkerRespond().invoke((Object)this, channelEntity.getChannelParam(), respondVO.getRecv())).booleanValue()) {
                LOGGER.info("\u5efa\u7acb\u94fe\u8def\u5931\u8d25:" + channelName + ",\u5931\u8d25\u7684\u62a5\u6587:" + respondVO.getRecv());
                return;
            }
            LinkerManager.updateEntity4LinkStatus(channelName, true);
            LOGGER.info("\u5efa\u7acb\u94fe\u8def\u6210\u529f:" + channelName);
        }
        catch (InvocationTargetException ie) {
            LOGGER.info("\u5efa\u7acb\u94fe\u8def\u5931\u8d25:" + channelName + ",\u539f\u56e0:" + ie.getTargetException());
        }
        catch (Exception e) {
            LOGGER.info("\u5efa\u7acb\u94fe\u8def\u5931\u8d25:" + channelName + ",\u539f\u56e0:" + e.getMessage());
        }
    }
}

