/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.initialize;

import cn.foxtech.channel.common.linker.LinkerMethodScanner;
import cn.foxtech.channel.common.linker.LinkerScheduler;
import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.channel.common.scheduler.ChannelRedisScheduler;
import cn.foxtech.channel.common.service.EntityManageService;
import cn.foxtech.channel.common.service.RedisTopicRespondDeviceService;
import cn.foxtech.channel.common.service.RedisTopicRespondManagerService;
import cn.foxtech.common.entity.entity.ChannelEntity;
import cn.foxtech.common.entity.entity.ConfigEntity;
import cn.foxtech.common.status.ServiceStatusScheduler;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChannelInitialize {
    @Autowired
    private ChannelRedisScheduler channelRedisScheduler;
    @Autowired
    private ServiceStatusScheduler serviceStatusScheduler;
    @Autowired
    private RedisTopicRespondManagerService redisTopicRespondManagerService;
    @Autowired
    private RedisTopicRespondDeviceService redisTopicRespondDeviceService;
    @Autowired
    private EntityManageService entityManageService;
    @Autowired
    private LinkerScheduler linkerScheduler;
    @Autowired
    private ChannelProperties channelProperties;
    @Autowired
    private LinkerMethodScanner linkerMethodScanner;

    public void initialize() {
        HashSet<String> others = new HashSet<String>();
        this.initialize(others);
    }

    public void initialize(Set<String> others) {
        this.serviceStatusScheduler.initialize();
        this.serviceStatusScheduler.schedule();
        this.channelProperties.initialize();
        HashSet<String> consumer = new HashSet<String>();
        consumer.add(ConfigEntity.class.getSimpleName());
        consumer.add(ChannelEntity.class.getSimpleName());
        consumer.addAll(others);
        this.entityManageService.instance(consumer);
        this.entityManageService.initLoadEntity();
        this.redisTopicRespondDeviceService.schedule();
        this.redisTopicRespondManagerService.schedule();
        this.channelRedisScheduler.schedule();
        if (this.channelProperties.getLinkerMode().booleanValue()) {
            this.linkerMethodScanner.loadJar();
            this.linkerMethodScanner.scanMethod();
            this.linkerScheduler.initialize();
            this.linkerScheduler.schedule();
        }
    }
}

