/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.api;

import cn.foxtech.channel.common.api.ChannelServerAPI;
import cn.foxtech.channel.common.linker.LinkerEntity;
import cn.foxtech.channel.common.linker.LinkerManager;
import cn.foxtech.channel.common.linker.LinkerMethodEntity;
import cn.foxtech.channel.common.linker.LinkerMethodTemplate;
import cn.foxtech.channel.common.properties.ChannelProperties;
import cn.foxtech.channel.common.service.EntityManageService;
import cn.foxtech.channel.domain.ChannelRequestVO;
import cn.foxtech.channel.domain.ChannelRespondVO;
import cn.foxtech.common.entity.entity.ChannelEntity;
import cn.foxtech.core.exception.ServiceException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChannelClientAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelClientAPI.class);
    @Autowired
    private ChannelProperties channelProperties;
    @Autowired
    private ChannelServerAPI channelServerAPI;
    @Autowired
    private EntityManageService entityManageService;
    @Autowired
    private LinkerMethodTemplate methodTemplate;

    public ChannelRespondVO execute(ChannelRequestVO requestVO) throws ServiceException {
        this.interceptIsNotLinked(requestVO);
        ChannelRespondVO respondVO = this.channelServerAPI.execute(requestVO);
        this.interceptDetectLink(respondVO);
        return respondVO;
    }

    public void publish(ChannelRequestVO requestVO) throws ServiceException {
        this.interceptIsNotLinked(requestVO);
        this.channelServerAPI.publish(requestVO);
    }

    private void interceptIsNotLinked(ChannelRequestVO requestVO) {
        if (!this.channelProperties.getLinkerMode().booleanValue()) {
            return;
        }
        ChannelEntity channelEntity = this.entityManageService.getChannelEntity(requestVO.getName(), this.channelProperties.getChannelType());
        if (channelEntity == null) {
            return;
        }
        Object linkEncoder = channelEntity.getChannelParam().get("link-encoder");
        if (linkEncoder == null) {
            return;
        }
        LinkerMethodEntity methodEntity = this.methodTemplate.getMap().get(linkEncoder);
        if (methodEntity == null) {
            return;
        }
        LinkerEntity linkerEntity = LinkerManager.queryEntity(requestVO.getName());
        if (linkerEntity == null) {
            throw new ServiceException("\u6307\u5b9a\u7684linkerEntity\u4e0d\u5b58\u5728\uff1a" + requestVO.getName());
        }
        if (!linkerEntity.isLinked()) {
            throw new ServiceException("\u6307\u5b9a\u7684\u4ece\u7ad9\u5c1a\u672a\u5efa\u7acb\u94fe\u8def\uff1a" + requestVO.getName());
        }
    }

    private void interceptDetectLink(ChannelRespondVO respondVO) {
        if (!this.channelProperties.getLinkerMode().booleanValue()) {
            return;
        }
        if (respondVO.getCode() != 200) {
            return;
        }
        ChannelEntity channelEntity = this.entityManageService.getChannelEntity(respondVO.getName(), this.channelProperties.getChannelType());
        if (channelEntity == null) {
            return;
        }
        Object linkEncoder = channelEntity.getChannelParam().get("link-encoder");
        if (linkEncoder == null) {
            return;
        }
        LinkerMethodEntity methodEntity = this.methodTemplate.getMap().get(linkEncoder);
        if (methodEntity == null) {
            return;
        }
        Method decodeDetectLinkerRespond = methodEntity.getDecodeInterceptLinkerRespond();
        if (decodeDetectLinkerRespond == null) {
            return;
        }
        try {
            if (((Boolean)decodeDetectLinkerRespond.invoke((Object)this, channelEntity.getChannelParam(), respondVO.getRecv())).booleanValue()) {
                LinkerManager.updateEntity4ActiveLinker(respondVO.getName(), true);
            } else {
                LOGGER.info("\u62e6\u622a\u5230\u8bbe\u5907\u65ad\u5f00\u8fde\u63a5\u72b6\u6001\uff0c\u8fde\u63a5\u65ad\u5f00!");
                LinkerManager.updateEntity4ActiveLinker(respondVO.getName(), false);
            }
        }
        catch (InvocationTargetException ie) {
            LOGGER.info("\u62e6\u622a\u8bbe\u5907\u8fd4\u56de\u65f6\uff0c\u62a5\u6587\u89e3\u7801\u5931\u8d25:" + channelEntity.getChannelName() + ",\u539f\u56e0:" + ie.getTargetException());
        }
        catch (Exception e) {
            throw new ServiceException("\u62e6\u622a\u8bbe\u5907\u8fd4\u56de\u65f6\uff0c\u62a5\u6587\u89e3\u7801\u5931\u8d25:" + channelEntity.getChannelName() + ",\u539f\u56e0:" + e.getMessage());
        }
    }

    public List<ChannelRespondVO> receive() throws ServiceException {
        return this.channelServerAPI.report();
    }

    public void openChannel(String channelName, Map<String, Object> channelParam) throws Exception {
        this.channelServerAPI.openChannel(channelName, channelParam);
    }

    public void closeChannel(String channelName, Map<String, Object> channelParam) {
        this.channelServerAPI.closeChannel(channelName, channelParam);
    }

    public ChannelRespondVO manageChannel(ChannelRequestVO requestVO) throws ServiceException {
        return this.channelServerAPI.manageChannel(requestVO);
    }
}

