/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TempDirManageService {
    @Value(value="${spring.fox-service.service.type}")
    private String foxServiceType = "undefinedServiceType";
    @Value(value="${spring.fox-service.service.name}")
    private String foxServiceName = "undefinedServiceName";
    private String absolutePath;

    public void createTempDir() throws IOException {
        if (this.absolutePath == null) {
            File file = new File("");
            this.absolutePath = file.getAbsolutePath();
        }
        String pathName = this.absolutePath + "/temp/" + this.foxServiceType + "/" + this.foxServiceName;
        Path path = Paths.get(pathName, new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IOException("unable to create dir: " + path);
        }
    }

    public String getTempDir() {
        if (this.absolutePath == null) {
            File file = new File("");
            this.absolutePath = file.getAbsolutePath();
        }
        return this.absolutePath + "/temp/" + this.foxServiceType + "/" + this.foxServiceName;
    }
}

