/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.service;

import cn.foxtech.channel.common.service.EntityManageService;
import cn.foxtech.common.entity.entity.ConfigEntity;
import cn.foxtech.common.entity.manager.EntityConfigManager;
import cn.foxtech.common.entity.manager.RedisConsoleService;
import cn.foxtech.common.utils.Maps;
import cn.foxtech.common.utils.file.FileTextUtils;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.core.exception.ServiceException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
public class ConfigManageService {
    @Autowired
    private RedisConsoleService logger;
    @Autowired
    private EntityManageService entityManageService;
    @Autowired
    private EntityConfigManager entityConfigManager;
    @Value(value="${spring.fox-service.service.type}")
    private String foxServiceType = "undefinedServiceType";
    @Value(value="${spring.fox-service.service.name}")
    private String foxServiceName = "undefinedServiceName";

    public Map<String, Object> getConfigParam(String configName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ConfigEntity configEntity = this.entityManageService.getConfigEntity(this.foxServiceName, this.foxServiceType, configName);
        if (configEntity == null) {
            this.logger.error("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u914d\u7f6e\u4fe1\u606f:" + configName);
            return result;
        }
        return configEntity.getConfigValue();
    }

    public <T> T getOrDefaultValue(String configName, Class<T> clazz, Object ... keys) {
        Map<String, Object> configParam = this.getConfigParam(configName);
        return (T)Maps.getOrDefault(configParam, clazz, (Object[])keys);
    }

    public Map<String, Object> loadInitConfig(String configName, String classpathFile) {
        try {
            File file = ResourceUtils.getFile((String)("classpath:" + classpathFile));
            String json = FileTextUtils.readTextFile((File)file);
            Map defaultConfig = (Map)JsonUtils.buildObject((String)json, Map.class);
            this.entityConfigManager.setConfigEntity("serverConfig", defaultConfig);
            Map<String, Object> systemConfig = this.getConfigParam("serverConfig");
            HashMap<String, Object> configValue = new HashMap<String, Object>();
            configValue.putAll(defaultConfig);
            configValue.putAll(systemConfig);
            return configValue;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new ServiceException(e.getMessage());
        }
    }
}

