/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.channel.common.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
public class ChannelProperties {
    @Autowired
    private AbstractEnvironment environment;
    @Value(value="${spring.fox-service.model.name}")
    private String channelType;
    private Boolean logger = false;
    private String initMode;
    private Boolean linkerMode;
    private Map<String, Object> linkEncoderJars;

    public void initialize() {
        this.initMode = (String)this.environment.getProperty("spring.channel.init-mode", String.class, (Object)"redis");
        this.linkerMode = (Boolean)this.environment.getProperty("spring.channel.link-mode", Boolean.class, (Object)false);
        this.linkEncoderJars = this.getPropertyMap("spring.channel.link-encoder-jar");
    }

    private Map<String, Object> getPropertyMap(String head) {
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        for (PropertySource propertySource : this.environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                rtn.put(key, propertySource.getProperty(key));
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : rtn.keySet()) {
            if (!key.startsWith(head + ".")) continue;
            result.put(key, rtn.get(key));
        }
        return result;
    }

    public AbstractEnvironment getEnvironment() {
        return this.environment;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public Boolean getLogger() {
        return this.logger;
    }

    public String getInitMode() {
        return this.initMode;
    }

    public Boolean getLinkerMode() {
        return this.linkerMode;
    }

    public Map<String, Object> getLinkEncoderJars() {
        return this.linkEncoderJars;
    }

    public void setLogger(Boolean logger) {
        this.logger = logger;
    }
}

